#!/bin/bash
# BUG770509: Add date/time and useful system info to midnight dmesg
# Must be run with root privilege
#
user_processes=$(( $(ps --ppid 2 -p 2 --deselect | wc -l) - 1 ))
kernel_processes=$(( $(ps --ppid 2 -p 2 | wc -l) - 1 ))
current_datetime=$(date -Iseconds)

oom_kill=$(grep oom_kill < /proc/vmstat | cut -d ' ' -f 2)
message="TOD: $current_datetime U[$user_processes] K[$kernel_processes] O[$oom_kill]"
echo "<14>$message" > /dev/kmsg
