#!/bin/sh

arch=i386
kernel=linux-${arch}-kdump
initrd=initrd-${arch}-kdump

# Extract linux-i386 and initrd-i386 shipped with EOS.swi
echo "Appending stop-phys to crash kernel for ${1^}"

# BUG177802: In case we ship our own kernel other than the default
# EOS.swi/linux-i386 within our Psp in the future, this script has to be updated
# to use that kernel.

unzip -oq /mnt/flash/.boot-image.swi ${kernel} ${initrd} -d /tmp/image

# Note: The Linux kernel supports an initrd of concatenated cpio archives,
# however the "cpio" command doesn't handle extracting this gracefully. Naively
# feeding such a collection of archives to "cpio" will only extract the first
# archive. To further complicate matters, early loaded CPU microcode must be the
# first archive and must not be compressed. All subsequent archives are
# compressed independently before concatenation. Here, the pre-compressed
# archive containing platform-specific files for the kdump kernel is
# concatenated to the stock EOS initrd from the SWI.
cat /etc/"${1}"/stop-phys.initrd >> /tmp/image/${initrd}

# BUG213513
# Filter hugepages(z)= out of cmdline for crash kernel command line. Since
# these parameters are additive, it is not possible to simply use kexec
# --reuse-cmdline and override them with hugepages=0.
crash_cmd_line=$(tr " " "\n" </proc/cmdline |
                        grep -v '^crashkernel=' |
                        grep -v '^dmamem=' |
                        grep -v '^hugepages=' |
                        grep -v '^hugepagesz=' |
                        grep -v '^default_hugepagesz=' | tr "\n" " ")
crash_cmd_line="$crash_cmd_line dmamem=0 crashkernel=0 maxcpus=1 log_buf_len=32K \
                mce=off in_kdump irqpoll"
if blkid | grep -isq 'label="eos[_-]crash"'; then
    crash_cmd_line="$crash_cmd_line has_crash_partition"
fi

# Load up the crash kernel
# Arguments for this kexec --load-panic has to match the one in
# Aboot/rootfiles/lib/boot1
kexec --load-panic --initrd=/tmp/image/${initrd} \
      --command-line="$crash_cmd_line" /tmp/image/${kernel}

# Clean up
rm -rf /tmp/image
