#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import argparse
import traceback
import yaml

import CliExtensionLib
import CliExtensionValidator

def main( f ):
   contents = f.read()

   try:
      CliExtensionLib.loadSyntaxYaml( contents, checkVendor=True, verifyOnly=True )
   except ( yaml.YAMLError,
            CliExtensionValidator.CliExtensionValidationError,
            CliExtensionLib.CliExtensionLoadError ) as e:
      print( f'Error: Unable to parse syntax file {f.name} due to: {e}' )
      traceback.print_exc()

if __name__ == '__main__':
   parser = argparse.ArgumentParser( description='Process some integers.' )
   parser.add_argument( '-e', '--extension', dest='extension',
         type=argparse.FileType( 'r' ), required=True )
   args = parser.parse_args()
   main( args.extension )
