#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import time
import argparse
from DmfMockLib import DmfMockHelper

if __name__ == '__main__':
   parser = argparse.ArgumentParser( description='Mock DMF setup' )
   group = parser.add_mutually_exclusive_group( required=True )
   group.add_argument( '--init', action='store_true',
                       help=( "Setup DMF supported, LAG, chip, "
                                     "traffic policy and flex counters" ) )
   group.add_argument( '--setZtnStatus', action='store_true',
                       help="Setup ZTN" )
   group.add_argument( '--setTcamProfileStatus',
                       choices=[ 'dmf-full-match-push-vlan',
                                 'dmf-l3-l4-match-push-vlan',
                                 'dmf-l3-l4-offset-match-push-vlan',
                                 'dmf-inner-l2-match-push-vlan',
                                 'dmf-outer-l2-match-push-vlan',
                                 'dmf-strip-vxlan-match-push-vlan',
                                 'dmf-dzgre-match-push-vlan' ],
                       help="Setup TCAM profile" )
   group.add_argument( '--cvmlBootstrap', action='store_true',
                       help=( "CVML bootstrap to do DMF init, set ZTN status "
                                     "and setup" ) )

   parser.add_argument( '--sysname', type=str, default="ar",
                        help=( "Sysname for device under test (DUT) "
                               "default: ar" ) )

   args = parser.parse_args()
   with DmfMockHelper() as helper:
      if args.cvmlBootstrap:
         helper.init()
         helper.setZtnStatus()
         helper.setTcamProfileStatus( 'dmf-full-match-push-vlan' )

         # see https://github.com/bigswitch/cvml/pull/493#discussion_r1068652885
         time.sleep( 90 )

         helper.setTcamProfileStatus( 'dmf-l3-l4-match-push-vlan' )

         # ztn/status is reset to False on vEOS during the ZTN handshake process
         time.sleep( 30 )

         helper.setZtnStatus()
      elif args.init:
         helper.init()
      elif args.setZtnStatus:
         helper.setZtnStatus()
      else:
         helper.setTcamProfileStatus( args.setTcamProfileStatus )
