#!/bin/bash

# The authz policy is used by multiple agents and lives in /persist/sys/gnsi/authz/
# If there is not current Authz policy we put the default policy at the policy path
authzPersistPath="/persist/sys/gnsi/authz"
authzPolicyPath="${authzPersistPath}/policy.json"
allowAllPolicy='{"name": "authz-init","allow_rules":[{"name": "allow_all"}]}'

# If the directory doesn't exist, create it
mkdir -p $authzPersistPath

# Check if the policy exists
if [ ! -f $authzPolicyPath ]; then
   # If the policy doesn't exist, create it
   echo $allowAllPolicy > $authzPolicyPath
fi