# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

HARDWARE_SYSTEM_ABOOT_IDENTIFICATION_FAILED = Logging.LogHandle(
      "HARDWARE_SYSTEM_ABOOT_IDENTIFICATION_FAILED",
      severity=Logging.logWarning,
      fmt="Failed to identify the aboot version on this system",
      explanation="The aboot version could not be identified on this "
                  "system. If the aboot version is not compatible with the boot "
                  "image, the system may not behave reliably.",
      recommendedAction=Logging.CONTACT_SUPPORT )

HARDWARE_SYSTEM_ABOOT_INCOMPATIBLE = Logging.LogHandle(
      "HARDWARE_SYSTEM_ABOOT_INCOMPATIBLE",
      severity=Logging.logEmergency,
      fmt="Aboot version %s found on this system, "
          "version number >= %s is required",
      explanation="The Aboot version on this system is not compatible "
                  "with the current boot image. The system will be unusable.",
      recommendedAction="Please upgrade the Aboot version or downgrade the "
                        "boot image configured on this system." )

HARDWARE_SYSTEM_ABOOT_UPDATE_FAILED = Logging.LogHandle(
      "HARDWARE_SYSTEM_ABOOT_UPDATE_FAILED",
      severity=Logging.logError,
      fmt="The BIOS upgrade failed. Reason: %s",
      explanation="An error occurred when upgrading the BIOS. The log "
                  "message may contain a reason why the upgrade failed.",
      recommendedAction="Determine why the BIOS failed to install. If you are unsure"
                        " how to proceed, contact your support representative." )

HARDWARE_SYSTEM_ABOOT_UPDATE_SUCCEEDED = Logging.LogHandle(
      "HARDWARE_SYSTEM_ABOOT_UPDATE_SUCCEEDED",
      severity=Logging.logInfo,
      fmt="The BIOS upgrade succeeded.",
      explanation="The BIOS has been successfully upgraded.",
      recommendedAction=Logging.NO_ACTION_REQUIRED )
