# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import argparse

from RepoArg import RepoArgOp

class AddEnableDisableReposInOrder( argparse.Action ):
   """Adds arguments in ordered fashion. This is needed for saving the
      enable/disable repo arguments order"""

   def __call__( self, parser, namespace, values, option_string=None ):
      if not 'ordered_args' in namespace:
         setattr( namespace, 'ordered_args', [] )
      previous = namespace.ordered_args
      if self.dest == "enablerepo":
         previous.append( ( RepoArgOp.ENABLE, values ) )
      elif self.dest == "disablerepo":
         previous.append( ( RepoArgOp.DISABLE, values ) )
      else:
         raise Exception( f"Unexpected argument: { self.dest }" )

      setattr( namespace, 'ordered_args', previous )
