# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This file exists to hide the AgentGlobalConfigReactor
# from a normal python import of Agent

import os

import Tac

class AgentGlobalConfigReactor( Tac.Notifiee ):
   notifierTypeName = 'Agent::GlobalConfig'

   def __init__( self, config ):
      Tac.Notifiee.__init__( self, config )
      self.handleEnvironment()

   @Tac.handler( 'environment' )
   def handleEnvironment( self ):
      for segment in self.notifier().environment.split( ':' ):
         args = segment.split( '=', 1 )
         if len( args ) == 2:
            os.environ[ args[ 0 ] ] = args[ 1 ]
