#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Ark import ReversibleDict
from TypeFuture import TacLazyType

def statusType():
   return 'Ale::Counters::Status'

TunnelType = TacLazyType( "Tunnel::TunnelTable::TunnelType" )
tunnelStrToType = ReversibleDict( {
   'bgp labeled-unicast' : TunnelType.bgpLuTunnel,
   'bgp labeled-unicast forwarding' : TunnelType.bgpLuForwardingTunnel,
   'ip-in-ip' : TunnelType.ipInIpTunnel,
   'isis segment-routing' : TunnelType.srTunnel,
   'ldp' : TunnelType.ldpTunnel,
   'rsvp frr' : TunnelType.rsvpFrrTunnel,
   'rsvp ler' : TunnelType.rsvpLerTunnel,
   'rsvp ler sub' : TunnelType.rsvpLerSubTunnel,
   'static mpls' : TunnelType.staticTunnel,
   'ti-lfa' : TunnelType.tiLfaTunnel,
   'traffic-engineering segment-routing policy' :
   TunnelType.srTeSegmentListTunnel,
} )
tunnelTypeToStr = tunnelStrToType.reverse()
