# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from TypeFuture import TacLazyType
from Toggles.AleTcamToggleLib import (
   toggleJ2UnsharedPolicerEnabled,
   toggleTrafficPolicyUnsharedPolicerEnabled,
)

defaultProfile = Tac.Type( 'AleTcam::TcamProfileVersion' ).defaultProfile
defaultProfileName = Tac.Type( 'AleTcam::TcamSystemProfile' ).defaultProfileName
AleTcamFeatureName = Tac.Type( "AleTcam::AleTcamFeatureName" )
TcamFeaturePortQualSize = Tac.Type( 'AleTcam::TcamFeaturePortQualSize' )
TcamSliceReservationStage = \
         TacLazyType( "AleTcam::TcamSliceReservationStage" )
Constants = Tac.Type( 'AleTcam::Constants' )

def compoundNameTokens( name ):
   return name.replace( '!', ' ' )

# This feature list is platform-independent
featuresSupportingTcamPrefixLabelSize = [
   compoundNameTokens( AleTcamFeatureName.trafficPolicyPortIpv4 ),
   compoundNameTokens( AleTcamFeatureName.trafficPolicyPortIpv6 ),
]

def featureSupportsTcamPrefixLabelSize( featureName ):
   return featureName in featuresSupportingTcamPrefixLabelSize

def featureSupportsTcamPolicyMapPolicerUnsharedSize( featureName ):
   featuresSupportingTcamPolicyMapPolicerUnsharedSize = {
      compoundNameTokens( AleTcamFeatureName.qosIp ) : (
         toggleJ2UnsharedPolicerEnabled() ),
      compoundNameTokens( AleTcamFeatureName.qosIpv6 ) : (
         toggleJ2UnsharedPolicerEnabled() ),
      compoundNameTokens( AleTcamFeatureName.qosMac ) : (
         toggleJ2UnsharedPolicerEnabled() ),
      compoundNameTokens( AleTcamFeatureName.trafficPolicyPortIpv4 ) : (
         toggleTrafficPolicyUnsharedPolicerEnabled() ),
      compoundNameTokens( AleTcamFeatureName.trafficPolicyPortIpv6 ) : (
         toggleTrafficPolicyUnsharedPolicerEnabled() ),
   }
   return featuresSupportingTcamPolicyMapPolicerUnsharedSize.get( featureName,
                                                                  False )

def featureDisabled( featureName ):
   return featureName.endswith( Constants.disabled )

# Used to map a qualifier name to a CLI prefix. Used only in the internal
# qualifier related CLI cmds.
qualifierToCliPrefixMap = {
   'vlan' : 'global key field vlan',
}

def internalQualifierToCliPrefix( qualifier ):
   return qualifierToCliPrefixMap[ qualifier ]

def identicalProfiles( profile1, profile2 ):
   if profile1.isOverridingRedirectEnabled != profile2.isOverridingRedirectEnabled:
      return False
   if profile1.urlConfig != profile2.urlConfig:
      return False
   if sorted( profile1.feature.keys() ) != sorted( profile2.feature.keys() ):
      return False
   if len( profile1.internalQualifierSize ) != len( profile2.internalQualifierSize ):
      return False
   for ( qual, size ) in profile1.internalQualifierSize.items():
      if profile2.internalQualifierSize.get( qual, 0 ) != size:
         return False
   for featureName in profile1.feature:
      feature1 = profile1.feature[ featureName ]
      feature2 = profile2.feature[ featureName ]
      if not feature1.isEqual( feature2 ):
         return False
   return True

def copyFeatureEntity( srcFeatureEntity, dstFeatureEntity ):
   dstFeatureEntity.copy( srcFeatureEntity )

# a dictionary of slice to tcamProfileStatus, keyed by slice names
def tcamProfileSliceStatus( profileStatusDir ):
   if not profileStatusDir:
      return {}
   sliceToStatus = { k : v for k, v in profileStatusDir.items()
                     if k != 'tcamProfileStatusDir' }
   if 'tcamProfileStatusDir' in profileStatusDir:
      tcamProfileStatus = \
            profileStatusDir[ 'tcamProfileStatusDir' ].tcamProfileStatus
      for card, status in tcamProfileStatus.items():
         sliceToStatus[ card ] = status
   return sliceToStatus
