# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import random
import socket


def _isPortUnused( port, sockType ):
   s  = socket.socket( family=socket.AF_INET, type=sockType )
   try:
      s.bind( ('localhost', port) )
   except OSError as e:
      print( 'Port ', port, e )
      return False
   else:
      s.close()
   return True


def _unusedPortsGenerator():
   'Unused port generator'
   unusedPorts_ = list( range( 1024, 65535 ) )
   random.shuffle( unusedPorts_ )
   while unusedPorts_:
      port = unusedPorts_.pop()
      yield port


unusedPorts = _unusedPortsGenerator()


def _pickUnusedPort( socketType=None ):
   while True:
      try:
         port = next( unusedPorts )
      except StopIteration:
         # pylint: disable-next=raise-missing-from
         raise Exception( 'No more unused ports available' )

      if socketType:
         if _isPortUnused( port, socketType ):
            return port
      elif ( _isPortUnused( port, socket.SOCK_STREAM ) and
             _isPortUnused( port, socket.SOCK_DGRAM ) ):
         return port


def hopefullyUnusedTcpPort():
   return _pickUnusedPort( socket.SOCK_STREAM )


def hopefullyUnusedUdpPort():
   return _pickUnusedPort( socket.SOCK_DGRAM )


def hopefullyUnusedTcpAndUdpPort():
   return _pickUnusedPort()
