#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

FeatureId = Tac.Type( 'FlexCounters::FeatureId' )

def etbaFeatureStatusDir( featureStatusDir=None ):
   # pkgdeps: rpm ArfaCounters
   featureInfo = Tac.newInstance( "Arfa::ArfaCounterFeatureInfo", "" )
   if featureStatusDir is None:
      featureStatusDir = Tac.newInstance( "Tac::Dir", "featureStatusDir" )
   for featureId in featureInfo.isSupportedFeature:
      status = featureStatusDir.newEntity( "FlexCounters::FeatureStatus",
                                           featureId )
      status.featureId = featureId
      status.defaultState = False
   return featureStatusDir
