# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
import BgpLib
from CliPlugin.AsuPStoreModel import ReloadHitlessWarningReason

class BgpAsuPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   '''Bgp need to throw a warning for ASU2 hitless reload if Graceful-Restart is
   not enabled. AsuPStorePlugin's hitlessReloadSupported is used for this purpose.
   Other apis do not apply, and should not be registered.
   '''
   def __init__( self, bgpConfig, bgpVrfConfigDir ):
      self.bgpConfig = bgpConfig
      self.bgpVrfConfigDir = bgpVrfConfigDir
      AsuPStore.PStoreEventHandler.__init__( self )

   def hitlessReloadSupported( self ):
      warningList, blockingList = None, None
      if ( self.bgpConfig and
           self.bgpVrfConfigDir and 
           BgpLib.bgpNsfGRWarn( self.bgpConfig, self.bgpVrfConfigDir ) ):
         warningList = [ ReloadHitlessWarningReason( reason='bgpNoGrace' ) ]
      return ( warningList, blockingList )

def Plugin( ctx ):
   featureName = 'Bgp'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      bgpConfig = mg.mount( 'routing/bgp/config', 'Routing::Bgp::Config', 'r' )
      bgpVrfConfigDir = mg.mount( 'routing/bgp/vrf/config',
                                  'Routing::Bgp::VrfConfigDir', 'ri' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( featureName,
                                         BgpAsuPStoreEventHandler( bgpConfig,
                                                                bgpVrfConfigDir ) )
   else:
      ctx.registerAsuPStoreEventHandler( featureName,
                                         BgpAsuPStoreEventHandler( None, None ) )
