#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessWarningReason
from Toggles.StageMgrToggleLib import toggleStrataIgmpSnoopingAsuEnabled

__defaultTraceHandle__ = Tracing.Handle( "IgmpSnoopingAsu" )
t0 = __defaultTraceHandle__.trace0

class IgmpSnoopingAsuPStoreEventHandler( AsuPStore.PStoreEventHandler ):

   def __init__( self, status, pstatus ):
      self.status_ = status
      self.pstatus_ = pstatus
      AsuPStore.PStoreEventHandler.__init__( self )

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      vlanStatus = self.status_.vlanStatus

      if toggleStrataIgmpSnoopingAsuEnabled():
         pStatus = self.pstatus_.contextStatus
         for vlanId in vlanStatus:
            ctx = pStatus[ vlanId ]
            if ctx and ctx.querier and ctx.querierVersion != 'igmpVersion3' :
               warningList.append( ReloadHitlessWarningReason(
                  reason='igmpSnoopingQuerierVersion' ) )
               break
      else:
         # Check for the existence of a querier
         for vlanId in vlanStatus:
            # pylint: disable-next=singleton-comparison
            if vlanStatus[ vlanId ].useVlanFloodset == False:
               warningList.append( ReloadHitlessWarningReason(
                  reason='igmpSnoopingEnabled' ) )
               break

      return ( warningList, blockingList )

def Plugin( ctx ):
   featureName = 'IgmpSnooping'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      status = mg.mount( 'bridging/igmpsnooping/forwarding/status',
                         'Bridging::IgmpSnooping::Status', 'r' )
      pstatus = mg.mount( 'bridging/igmpsnooping/protocol/status',
                          'Bridging::IgmpSnooping::IgmpProtocolStatus', 'r' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler( featureName,
                                         IgmpSnoopingAsuPStoreEventHandler(
                                            status, pstatus ) )
   else:
      ctx.registerAsuPStoreEventHandler( featureName,
                                         IgmpSnoopingAsuPStoreEventHandler(
                                            None, None ) )
