# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import AsuPStore
import Tac

__defaultTraceHandle__ = Tracing.Handle( "LldpAsu" )
t0 = Tracing.trace0
t1 = Tracing.trace1

class LldpPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   def __init__( self, stores ):
      self.stores = stores
      super().__init__()
   
   def getKeys( self ):
      return [ 'nbrClassificationStatus' ]
   
   def save( self, pStoreIO ):
      pStoreIO.set( self.getKeys()[ 0 ], self.storeNbrClassificationStatus()  )

   def getSupportedKeys( self ):
      return self.getKeys()

   def hitlessReloadSupported( self ):
      t0( self.__class__.__name__ )
      return ( [], [] )
   
   def restorNeighborCol( self, nbrCol, nbrStatus ):
      for mac, nbr in nbrStatus.items():
         nbrInfo = nbrCol.setdefault( mac, {} )
         nbrInfo[ 'intfId' ] = nbr.intfId
         nbrInfo[ 'classification' ] = nbr.classification.telephone
         nbrInfo[ 'source' ] = nbr.source

   def storeNbrClassificationStatus( self ):
      t0( self.__class__.__name__, "store Neighbor Classification Status." )
      nbrClassificationStatus = self.stores[ "nbrClassificationStatus" ]
      pyCol = {}
      nbrCol = pyCol.setdefault( 'neighbor', {} )
      self.restorNeighborCol( nbrCol, nbrClassificationStatus.neighbor )
      lldpNbrCol = pyCol.setdefault( 'lldpNeighbor', {} )
      self.restorNeighborCol( lldpNbrCol, nbrClassificationStatus.lldpNeighbor )
      cliNbrCol = pyCol.setdefault( 'cliNeighbor', {} )
      self.restorNeighborCol( cliNbrCol, nbrClassificationStatus.cliNeighbor )
      phoneCol = pyCol.setdefault( 'phone', {} )
      for key, value in nbrClassificationStatus.phone.items():
         phoneCol[ key ] = value
      return pyCol

def Plugin( ctx ):
   featureName = 'Lldp'

   if ctx.opcode() == 'GetSupportedKeys':
      ctx.registerAsuPStoreEventHandler( featureName,
            LldpPStoreEventHandler( None ) )
      return

   entityManager = ctx.entityManager()
   mg = entityManager.mountGroup()
   stores = {}

   neighborClassificationStatus = mg.mount( 'identity/nbrClassification/status',
                                            'Identity::NbrClassification::Status',
                                            'r' )
   mg.close( blocking=True )
   # Stuff we actually store for ASU2
   stores[ 'nbrClassificationStatus' ] = neighborClassificationStatus

   ctx.registerAsuPStoreEventHandler( featureName,
                                      LldpPStoreEventHandler( stores ) )
   
