#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AsuPStore
from CliPlugin.AsuPStoreModel import ReloadHitlessBlockingReason

class PbrPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   ''' When there is at least one pbr policy is configured,
   this configuration will block ASU2 hitless reload.
   '''
   def __init__( self, pbrConfig ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.pbrConfig_ = pbrConfig

   def hitlessReloadSupported( self ):
      warningList, blockingList = [], []
      if self.pbrConfig_ and len( self.pbrConfig_.pmapType.pmap ) != 0:
         blockingList.append( ReloadHitlessBlockingReason( reason='pbrConfigured' ) )
      return ( warningList, blockingList )
   
def Plugin( ctx ):
   featureName = 'Pbr'
   if ctx.opcode() == 'CheckHitlessReloadSupported':
      entityManager = ctx.entityManager()
      mg = entityManager.mountGroup()
      pbrConfig = mg.mount( 'pbr/input/pmap/cli', 'Pbr::PbrConfig', 'r' )
      mg.close( blocking=True )
      ctx.registerAsuPStoreEventHandler(
            featureName,
            PbrPStoreEventHandler( pbrConfig ) ) 
   else:
      ctx.registerAsuPStoreEventHandler(
            featureName,
            PbrPStoreEventHandler( None ) ) 

