# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import AsuPStore
import Tac

class SmbusPStoreEventHandler( AsuPStore.PStoreEventHandler ):
   def __init__( self, smbusParDir ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.smbusParDir_ = smbusParDir

   def getSmbusNames( self ):
      smbusNames = [ 'Smbus' ]
      if 'slice' in self.smbusParDir_:
         smbusDir = self.smbusParDir_[ 'slice' ]
         for smbusConfig in smbusDir.values():
            # pylint: disable-next=consider-using-f-string
            smbusNames.append( 'Smbus-%s' % smbusConfig.name )
      return smbusNames

   def save( self, pStoreIO ):
      smbusNames = self.getSmbusNames()
      if smbusNames:
         pStoreIO.set( "smbusNames", smbusNames )

   def getSupportedKeys( self ):
      return [ 'smbusNames' ]

   def getKeys( self ):
      keys = []
      if self.getSmbusNames():
         keys.append( 'smbusNames' )
      return keys

def Plugin( ctx ):
   featureName = "Smbus"

   if ctx.opcode() == 'GetSupportedKeys':
      ctx.registerAsuPStoreEventHandler(
            featureName, SmbusPStoreEventHandler( None ) )
      return

   entityManager = ctx.entityManager()
   mg = entityManager.mountGroup()

   smbusParDir = mg.mount( "hardware/smbus", "Tac::Dir", "ri" )
   mg.close( blocking=True )

   ctx.registerAsuPStoreEventHandler(
         featureName, SmbusPStoreEventHandler( smbusParDir ) )
