#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import AsuPStore
import Swag
import Tracing

t0 = Tracing.trace0

class SwagPStoreEventHandler( AsuPStore.PStoreEventHandler ):

   def __init__( self, swagStatus ):
      t0( 'SwagPStoreEventHandler.__init__' )
      AsuPStore.PStoreEventHandler.__init__( self )
      self.swagStatus_ = swagStatus

   def save( self, pStoreIO ):
      t0( 'SwagPStoreEventHandler.save' )
      pStoreIO.set( 'swagActiveMemberId',
                     self.swagStatus_.activeSupervisorMemberId )
      pStoreIO.set( 'swagMemberId', self.swagStatus_.candidateMemberId )
      pStoreIO.set( 'swagVlan', self.swagStatus_.candidateVlan )

      # We will be pstoring the inferred incarnation 3 role of the device
      # given our memberId, as opposed to our current swagRole.
      futureSwagRole = Tac.Type( 'SwagAgent::SwagConfigSm' ).memberRole(
         self.swagStatus_.candidateMemberId
      )
      pStoreIO.set( 'swagRole', futureSwagRole )

   def getSupportedKeys( self ):
      return [ 'swagActiveMemberId', 'swagMemberId', 'swagRole', 'swagVlan' ]

   def getKeys( self ):
      return [ 'swagActiveMemberId', 'swagMemberId', 'swagRole', 'swagVlan' ]

def Plugin( ctx ):

   if not Swag.swagMode():
      return

   if ctx.opcode() == 'GetSupportedKeys':
      ctx.registerAsuPStoreEventHandler( 'Swag',
                                         SwagPStoreEventHandler( None ) )
      return

   entityManager = ctx.entityManager()
   mg = entityManager.mountGroup()
   swagStatus = mg.mount( 'swag/status', 'Swag::SwagStatus', 'r' )
   t0( "asuStore: ", swagStatus )

   def registerEventHandlers():
      ctx.registerAsuPStoreEventHandler(
         'Swag', SwagPStoreEventHandler( swagStatus ) )
   ctx.mountsComplete( mg, 'SwagAsuPStore', registerEventHandlers )
