# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import QuickTrace
import sys
import Tracing

def initialize( filename="qt-%d.out", sizes="", foreverLogPath="",
                foreverLogIndex=0, maxStringLen=24 ):
   QuickTrace.initialize( filename, sizes, foreverLogPath, foreverLogIndex,
                          maxStringLen )

Var = QuickTrace.Var

def trace_h( level, qLevel, fname, args ):
   name = ""
   if fname:
      f = sys._getframe( 2 ) # pylint: disable-msg=W0212
      name = f.f_code.co_name + ": "
      if "self" in f.f_locals:
         name = f.f_locals[ "self" ].__class__.__name__ + "::" + name
   # Tracing.trace assumes frame 2. Give defaultTrraceHandle 3.
   Tracing._trace_h( Tracing.defaultTraceHandle( 3 ), # pylint: disable-msg=W0212
                     Tracing.levelToEnumValue_[ level ],
                     3, name + " ".join( [ str( x ) for x in args ] ) )
   # QuickTrace assumes frame 2. Give it an additional offset of 1.
   QuickTrace.tracef( qLevel, 1, ( name, ) + args )

# pylint: disable-msg=C0321
# trace<n>
def trace0( *args ): trace_h( 0, 0, False, args )
def trace1( *args ): trace_h( 1, 1, False, args )
def trace2( *args ): trace_h( 2, 2, False, args )
def trace3( *args ): trace_h( 3, 3, False, args )
def trace4( *args ): trace_h( 4, 4, False, args )
def trace5( *args ): trace_h( 5, 5, False, args )
def trace6( *args ): trace_h( 6, 6, False, args )
def trace7( *args ): trace_h( 7, 7, False, args )
def trace8( *args ): trace_h( 8, 8, False, args )
def trace9( *args ): trace_h( 9, 9, False, args )
def traceX( level, *args ): trace_h( level, level, False, args )
def traceXX( level, qLevel, *args ): trace_h( level, qLevel, False, args )

# tracef<n>: prepend class::function to traced message
def tracef0( *args ): trace_h( 0, 0, True, args )
def tracef1( *args ): trace_h( 1, 1, True, args )
def tracef2( *args ): trace_h( 2, 2, True, args )
def tracef3( *args ): trace_h( 3, 3, True, args )
def tracef4( *args ): trace_h( 4, 4, True, args )
def tracef5( *args ): trace_h( 5, 5, True, args )
def tracef6( *args ): trace_h( 6, 6, True, args )
def tracef7( *args ): trace_h( 7, 7, True, args )
def tracef8( *args ): trace_h( 8, 8, True, args )
def tracef9( *args ): trace_h( 9, 9, True, args )
def tracefX( level, *args ): trace_h( level, level, True, args )
def tracefXX( level, qLevel, *args ): trace_h( level, qLevel, True, args )
# pylint: enable-msg=C0321
