#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac


def tacBrTypeVal( brTypeStr ):
   enum = Tac.Type( 'Bridging::BrType' )
   return getattr( enum, brTypeStr )

def vlanIdToBrId( vlanId ):
   '''
   convert Bridging::VlanId to Bridging::BridgeId
   '''
   brType = tacBrTypeVal ( 'brTypeVlan' )
   BridgeId = Tac.Type( "Bridging::BridgeId" )
   return BridgeId( brType, vlanId ).constMe()

def vniToBrId( vni ):
   '''
   convert a VNI to Bridging::BridgeId
   '''
   brType = tacBrTypeVal ('brTypeVni')
   BridgeId = Tac.Type( "Bridging::BridgeId")
   return BridgeId( brType, vni ).constMe()

def extendedVlanIdToBrId( extendedVlanId ):
   '''
   convert Bridging::ExtendedVlanId to Bridging::BridgeId
   '''
   brType = tacBrTypeVal( 'brTypeExtendedVlan' )
   BridgeId = Tac.Type( "Bridging::BridgeId" )
   return BridgeId( brType, extendedVlanId ).constMe()
