#!/usr/bin/env python3

# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

class CeosMode( object ): # pylint: disable=useless-object-inheritance
   checkKernelVersion = True
   disabledAgents = []
   enableCapi = False
   enableHostSyslog = False
   enableRoutingModelMultiAgent = False
   disableSpanningTree = False
   disableLldp = False
   generateKickStart = False
   enableRouting = False
   enableRouting6 = False
   enableRoutedMode = False
   configHostname = False
   extKickstart = False
   linuxKernelForwarding = False
   enableALPMMode = False
   genDmamemContainerConfig = False
   genDsfConfig = False
   enableDsfClusterConfig = False

class CeosLabMode( CeosMode ):
   checkKernelVersion = False
   generateKickStart = True
   disabledAgents = [
      "LicenseManager", "PowerFuse", "PowerManager", "Thermostat", "LedPolicy",
      "StandbyCpld",
   ]

class CeosRouterMode( CeosMode ):
   checkKernelVersion = False
   enableCapi = True
   enableRouting = True
   enableRoutedMode = True
   configHostname = True
   generateKickStart = True
   disabledAgents = [
      "LicenseManager", "PowerFuse", "PowerManager", "Thermostat", "LedPolicy",
      "StandbyCpld", "SampledFlowTrac",
      "CloudHa", "Bfd", "Ipsec", "Tunnel", "Acl", "Qos", "PortSec",
      "TopoAgent", "L2Rib", "LacpTx", "Lag", "LacpTxAgent",
      "McastCommon", "McastCommon6", "IgmpSnooping", "Stp", "StpTxRx", "StpTopology",
   ]
   extKickstart = True
   linuxKernelForwarding = True

class CeosSaiMode( CeosMode ):
   checkKernelVersion = False
   enableCapi = True
   enableRoutingModelMultiAgent = True
   enableRouting = True
   enableRouting6 = True
   disableSpanningTree = True
   generateKickStart = True
   # BUG274076 tracks the progress of the agent blacklist for the SAI mode
   disabledAgents = [
      # Unicast Protocols with empty config
      "KernelFib", "Bfd", "Ipv6RouterAdvt", "ArpInspection",
      # Multicast Protocols are disabled by default
      # L2 Protocols that start with empty config
      "IgmpSnooping", "Stp", "StpTxRx", "Fhrp", "Lldp",
   ]
   enableALPMMode = True

class CeosDsfMode( CeosMode ):
   checkKernelVersion = False
   enableRoutingModelMultiAgent = True
   disableSpanningTree = True
   disableLldp = True
   generateKickStart = True
   enableRouting = True
   enableRouting6 = True
   genDmamemContainerConfig = True
   genDsfConfig = True
   enableDsfClusterConfig = True
   # BUG274076 tracks the progress of the agent blacklist for the SAI mode
   # Copying over the agent blacklist from SAI mode, which works for now.
   # TODO I will have to fine tune this more as we continue developing on the DSF
   # simulation.
   disabledAgents = [
      # Multicast Protocols are disabled by default
      # L2 Protocols that start with empty config
      "IgmpSnooping", "Fhrp", "Lldp", "SandAegis", "SandPtp", "SandPacketTracer",
   ]

Modes = {
   "lab" : CeosLabMode,
   "ceosr" : CeosRouterMode,
   "sai" : CeosSaiMode,
   "dsf": CeosDsfMode,
   "unknown" : CeosMode,
}
