#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from collections import namedtuple
import random
import Tac
from TypeFuture import TacLazyType
from CfmTypes import tacMepIntfL2SwitchportMode

ccmTxIntervalUnitMultiplier = { 'seconds' : 1, 'milliseconds' : 0.001,
                                'minutes' : 60 }

def getCcmTxInterval( ccmTxInterval=1, unit='seconds' ):
   return float( ccmTxInterval ) * ccmTxIntervalUnitMultiplier[ unit ]

CcmTxIntervalWithUnit = namedtuple( 'CcmTxIntervalWithUnit', 'ccmTxInterval, unit' )
ccmTxIntervalToCliToken = {}
randomCcmTxIntervalUnit = random.choice( list( ccmTxIntervalUnitMultiplier ) )
CcmTxIntervalPdu = [ 0 ]
for ccmTxIntervalWithUnit in [ CcmTxIntervalWithUnit( 3.33, 'milliseconds' ),
                               CcmTxIntervalWithUnit( 10, 'milliseconds' ),
                               CcmTxIntervalWithUnit( 100, 'milliseconds' ),
                               CcmTxIntervalWithUnit( 1, 'seconds' ),
                               CcmTxIntervalWithUnit( 10, 'seconds' ),
                               CcmTxIntervalWithUnit( 1, 'minutes' ),
                               CcmTxIntervalWithUnit( 10, 'minutes' ) ]:
   ccmTxIntervalToCliToken[
      getCcmTxInterval(
         **ccmTxIntervalWithUnit._asdict() # pylint: disable=protected-access
      ) ] = ccmTxIntervalWithUnit
   CcmTxIntervalPdu.append( getCcmTxInterval(
         **ccmTxIntervalWithUnit._asdict() # pylint: disable=protected-access
      ) )
defaultCcmTxIntervalWithUnit = CcmTxIntervalWithUnit( 1, 'seconds' )
assert defaultCcmTxIntervalWithUnit in ccmTxIntervalToCliToken.values()

ieeeMdNameMaxLen = 43
ieeeMaNameMaxLen = 45

CcmDefectAlarmCliData = {
   'cross-connection' : 'cross connection defects can raise alarms',
   'error-ccm' : 'invalid CCMs can raise alarms',
   'loc-state' : 'loss of connectivity can raise alarms',
   'rdi-ccm' : 'CCMs with rdi bit set can raise alarms',
}

CcmDefectAlarmEnum = TacLazyType( "Cfm::CcmDefectAlarm" )

def getDefaultCcmDefectAlarm():
   defaultCcmDefectAlarm = [ CcmDefectAlarmEnum.ccmDefectAlarmRemoteCcm,
                             CcmDefectAlarmEnum.ccmDefectAlarmRdiCcm ]
   return defaultCcmDefectAlarm

def getCcmDefectAlarmEnumFromCli( defectName ):
   if defectName == 'cross-connection':
      return CcmDefectAlarmEnum.ccmDefectAlarmXconCcm
   if defectName == 'error-ccm':
      return CcmDefectAlarmEnum.ccmDefectAlarmErrorCcm
   if defectName == 'loc-state':
      return CcmDefectAlarmEnum.ccmDefectAlarmRemoteCcm
   if defectName == 'mac-status':
      return CcmDefectAlarmEnum.ccmDefectAlarmMacStatus
   if defectName == 'rdi-ccm':
      return CcmDefectAlarmEnum.ccmDefectAlarmRdiCcm
   return None

def getDefectAlarmNameFromEnum( defectAlarm ):
   if defectAlarm == CcmDefectAlarmEnum.ccmDefectAlarmRdiCcm:
      return "RDI"
   elif defectAlarm == CcmDefectAlarmEnum.ccmDefectAlarmMacStatus:
      return "MAC Status"
   elif defectAlarm == CcmDefectAlarmEnum.ccmDefectAlarmRemoteCcm:
      return "LOC"
   elif defectAlarm == CcmDefectAlarmEnum.ccmDefectAlarmErrorCcm:
      return "Invalid CCM"
   elif defectAlarm == CcmDefectAlarmEnum.ccmDefectAlarmXconCcm:
      return "Cross Connect CCM"
   return ""

def addMepIntfSupported(
      cfmHwSupportedStatus, mepDirection, mepIntfType, serviceIntfType,
      mepIntfL2SwitchportMode=tacMepIntfL2SwitchportMode.
      mepIntfL2SwitchportModeNone ):
   mepIntfSupported = Tac.Value( "Cfm::MepIntfSupported",
                                 mepDirection, mepIntfType, serviceIntfType,
                                 mepIntfL2SwitchportMode )
   cfmHwSupportedStatus.mepIntfSupported.add( mepIntfSupported )
