#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from TypeFuture import TacLazyType

def tacIntf( intf ):
   return Tac.Value( 'Arnet::IntfId', intf )

def tacDot1qEncap( outer, inner ):
   return Tac.Value( 'Bridging::Dot1qEncap', outer, inner )

def tacLmStatsEntry( localRx=0, localTx=0, remoteRx=0, remoteTx=0, time=0 ):
   return Tac.Value( "Cfm::LmStatsEntry", localRx,
                     localTx, remoteRx,
                     remoteTx, time )

def tacLmStats():
   return Tac.Value( "Cfm::LmStats" )

def tacLmStatsEntryPair():
   return Tac.Value( "Cfm::LmStatsEntryPair" )

remoteMepLmProgrammingStr = "Cfm::RemoteMepLmProgrammingState"

def tacRemoteMepLmProgrammingState( mepState ):
   return Tac.Value( remoteMepLmProgrammingStr, mepState, Tac.utcNow() )

tacCfmConstants = TacLazyType( "Cfm::Constants" )
tacMdLevel = Tac.Type( 'Cfm::MdLevel' )
tacMdNameFormat = Tac.Type( 'Cfm::MdNameFormat' )
tacMaNameFormat = Tac.Type( 'Cfm::MaNameFormat' )
tacMepDirection = Tac.Type( 'Cfm::MepDirection' )
tacLocalMepProgrammingState = TacLazyType( 'Cfm::LocalMepState' )
tacLocalMepProgState = TacLazyType( 'Cfm::LocalMepProgState' )
tacLocalMepCcmRxState = TacLazyType( 'Cfm::LocalMepCcmRxState' )
tacLocalMepCcmTxState = TacLazyType( 'Cfm::LocalMepCcmTxState' )
tacLocalMepAisState = TacLazyType( 'Cfm::LocalMepAisState' )
tacRemoteMepProgrammingState = TacLazyType( 'Cfm::RemoteMepState' )
tacRemoteMepCcmState = TacLazyType( 'Cfm::RemoteMepCcmState' )
tacRemoteMepSlmState = Tac.Type( 'Cfm::RemoteMepSlmState' )
tacRemoteMepLmState = Tac.Type( 'Cfm::RemoteMepLmState' )
tacRemoteMepLmStateNode = Tac.typeNode( 'Cfm::RemoteMepLmState' )
defaultMepDirection = tacMepDirection.MepDirectionUnknown
defaultPrimaryVlanId = 0
tacTimeUnit = TacLazyType( 'Cfm::TimeUnit' )
tacPmTxInterval = Tac.Type( "Cfm::PmTxInterval" )
tacAisTxIntervalUnit = Tac.Type( 'Cfm::AisConfig::AisTxIntervalUnit' )
tacLmMode = Tac.Type( 'Cfm::LmMode' )
tacOpCode = Tac.Type( 'Cfm::OpCode' )
tacLmStatsType = TacLazyType( 'Cfm::LmStats' )
tacDmMode = Tac.Type( 'Cfm::DmMode' )
tacSlmMode = Tac.Type( 'Cfm::SlmMode' )
tacRemoteMepDmState = Tac.Type( 'Cfm::RemoteMepDmState' )
tacDmTimestampEntryType = Tac.Type( 'Cfm::DmTimestampEntry' )
tacStatEntryIdx = Tac.Type( 'Cfm::Smash::StatEntryIdx' )
tacPmOperMode = TacLazyType( 'Cfm::PmOperMode' )
tacCos = Tac.Type( 'Qos::Cos' )
defaultCcmCos = tacCos.max
tacPmMethod = Tac.Type( 'Cfm::PmMethod' )
tacCfmConst = TacLazyType( 'Cfm::Constants' )
tacCfmMulticastDAClassType = Tac.Type( 'Cfm::MulticastDAClassType' )
tacRemoteMepSlmState = Tac.Type( 'Cfm::RemoteMepSlmState' )
tacMepIntfType = Tac.Type( "Cfm::MepIntfType" )
tacMepIntfL2SwitchportMode = Tac.Type( 'Cfm::MepIntfL2SwitchportMode' )
tacMiConfig = TacLazyType( 'Cfm::MeasurementIntervalConfig' )

def tacRemoteMepDmProgrammingState( mepState ):
   return Tac.Value( "Cfm::RemoteMepDmProgrammingState", mepState, Tac.utcNow() )

def tacOpCodeEnumIntValue( enumStrVal ):
   return Tac.enumValue( 'Cfm::OpCode', enumStrVal )

def tacCcmMulticastEthAddr( mdLevel ):
   return Tac.Value(
      'Cfm::CfmMulticastEthAddr',
      tacCfmMulticastDAClassType.MulticastDAClass1, mdLevel ).ethAddr

def tacSmashMaKey( domainName, mdLevel, maName ):
   maKey = Tac.Value( 'Cfm::Smash::MaKey' )
   maKey.domainNameIs( domainName )
   maKey.mdLevel = mdLevel
   maKey.maName = maName
   return maKey

def tacSmashLocalMepKey( domainName, mdLevel, maName, localMepId ):
   maKey = tacSmashMaKey( domainName, mdLevel, maName )
   return Tac.Value( 'Cfm::Smash::LocalMepKey', maKey, localMepId )

def tacSmashRemoteMepKey( domainName, mdLevel, maName, localMepId, remoteMepId ):
   localMepKey = tacSmashLocalMepKey( domainName, mdLevel, maName, localMepId )
   return Tac.Value( 'Cfm::Smash::RemoteMepKey', localMepKey, remoteMepId )

def tacSlmSessionKey( slmTestId, cosValue ):
   return Tac.Value( "Cfm::SlmSessionKey", slmTestId, cosValue )

def tacSmashRemoteMepSlmSessionKey( smashRmepKey, slmSessionKey ):
   return Tac.Value(
      'Cfm::Smash::RemoteMepSlmSessionKey', smashRmepKey, slmSessionKey )

def tacRemoteMepSlmProgrammingState( mepState ):
   return Tac.Value( "Cfm::RemoteMepSlmProgrammingState", mepState, Tac.utcNow() )

def tacCfmDefectCode( defectCode ):
   return Tac.enumValue( "Cfm::DefectCode", defectCode )

def tacIntfVlan( intfId, vlanId ):
   return Tac.Value( 'CfmSw::IntfVlanTuple', intfId, vlanId )

def tacLocalMepCcmProgrammingState( mepCcmRxState, mepCcmTxState ):
   return Tac.Value( "Cfm::LocalMepCcmProgrammingState",
                           mepCcmRxState, mepCcmTxState, Tac.utcNow() )

def tacRemoteMepCcmProgrammingState( rMepCcmState ):
   return Tac.Value( "Cfm::RemoteMepCcmProgrammingState",
                                          rMepCcmState, Tac.utcNow() )

def tacLocalMepCfmProgrammingState( mepState ):
   return Tac.Value( "Cfm::LocalMepCfmProgrammingState",
                                          mepState, Tac.utcNow() )

def tacCcmDefectAlarm( defectAlarm ):
   return Tac.enumValue( "Cfm::CcmDefectAlarm", defectAlarm )

def tacMaNameWithFormat( name, maFormat ):
   return Tac.Value( "Cfm::MaNameWithFormat", name, maFormat )

def tacMdNameWithFormat( name, mdFormat ):
   return Tac.Value( "Cfm::MdNameWithFormat", name, mdFormat )
