# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

def chipSetFromMask( value=0 ):
   chipSet = Tac.Value( 'Ark::ChipSet' )
   bucketSize = 64
   bucketMask = ( 1 << bucketSize ) - 1
   chipSet.value[ 0 ] = value & bucketMask
   chipSet.value[ 1 ] = ( value >> bucketSize ) & bucketMask
   chipSet.value[ 2 ] = ( value >> ( 2 * bucketSize ) ) & bucketMask
   chipSet.value[ 3 ] = ( value >> ( 3 * bucketSize ) ) & bucketMask
   return chipSet

