# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# dummy import for 'hardware/ale/cpufabric/config'
# pkgdeps: rpm Ale

from CliPlugin.AleCpuFabric import (
   cpuFabricConfig,
   cpuFabricSliceStatus,
   thresholdShutdownSupported,
   showMonitorStatusHook,
)

def handleEnableHealthMonitoring( mode, args ):
   cpuFabricConfig.disableHealthMonitoring = False

def handleNoEnableHealthMonitoring( mode, args ):
   cpuFabricConfig.disableHealthMonitoring = True

def handleThresholdShutdown( mode, args ):
   cpuFabricConfig.numErrorsToPoweroff = args[ 'NUM_ERRORS' ]

def handleNoThresholdShutdown( mode, args ):
   cpuFabricConfig.numErrorsToPoweroff = \
            cpuFabricConfig.defaultNumErrorsToPoweroff

def handleActionNone( mode, args ):
   cpuFabricConfig.disableHealthRecoveryAction = True

def handleNoActionNone( mode, args ):
   cpuFabricConfig.disableHealthRecoveryAction = False

def handleHardwareCpuForwardingMonitor( mode, args ):
   status = 'disabled' if cpuFabricConfig.disableHealthMonitoring else 'enabled'
   print( 'CPU Forwarding monitor is', status )

   if thresholdShutdownSupported:
      print( 'Threshold to shutdown linecard:',
               cpuFabricConfig.numErrorsToPoweroff )

   for hook in showMonitorStatusHook:
      hook( cpuFabricSliceStatus )
