# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AgentCommandRequest import runCliPrintSocketCommand
from CliModel import cliPrinted
from CliDynamicSymbol import CliDynamicPlugin

BessdCountersShowModel = CliDynamicPlugin( "BessdCountersShowModel" )

# ---------------------------------------------------------------------------------
# show platform sfe memory counters
# ---------------------------------------------------------------------------------
def showBessdCountersMemHandler( mode, args ):
   modelClass = BessdCountersShowModel.CountersMemShowModel
   model = runCliPrintSocketCommand( mode.entityManager,
                                     'Sfe',
                                     'bess-counters-stats',
                                     '',
                                     mode,
                                     keepalive=True,
                                     connErrMsg='Sfe agent is inactive',
                                     model=modelClass )
   return cliPrinted( model ) if model else None
