# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Int, Model, Dict

class BessdCounterBlock( Model ):
   refCount = Int( help='Count of how many counters allocated from this block' )
   blockAddress = Int( help='internal memory location allocated for this block' )

class CountersMemShowModel( Model ):
   countersInBlock = Int( help='Number of counters in each block' )
   totalBlocks = Int( help='Number of blocks the system supports' )
   inUseBlocks = Int( help='Number of blocks currently used by the system' )
   inUseCounters = Int( help='Number of counters currently used by the system' )
   memoryUsed = \
      Int( help='Memory ( in KB ) used by the counters in use in the system' )
   blocks = Dict( keyType=int, valueType=BessdCounterBlock,
                  help='Dictionary of all counter blocks keyed by blockId' )
