#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from ArnetModel import IpGenericPrefix
from CliModel import Model, Dict, DeferredModel, Int
from CliPlugin.VrfCli import generateVrfCliModel
from CliPlugin import BgpCliModels

rfdRouteVrfModel = generateVrfCliModel( BgpCliModels.BgpRfdVrfModel,
      'Per VRF BGP route rfd information' )

# -----------------------------------------
# show bgp segment-routing prefix-segments
# -----------------------------------------
class PrefixSegment( Model ):
   sid = Int( help='The segment ID of the route' )
   localLabel = Int( help='The generated local label of the route' )

class PrefixSegments( DeferredModel ):
   prefixSegments = Dict( keyType=IpGenericPrefix, valueType=PrefixSegment,
         optional=True,
         help='Mapping of IPv4 or IPv6 prefixes to corresponding route segments' )
