#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentCommandRequest
from CliDynamicSymbol import CliDynamicPlugin
from CliPlugin.ArBgpCli import (
   ArBgpAsyncCliCommand,
   ArBgpCliCommand,
)
from CliPlugin.BgpCliHelperCli import convertPeerAddr
from CliPlugin.RoutingBgpShowCli import (
   ArBgpShowOutput,
   summaryVrfModel,
)
from CliModel import cliPrinted
from IpLibConsts import DEFAULT_VRF

BgpDpsCliModels = CliDynamicPlugin( "BgpDpsCliModels" )

@ArBgpShowOutput( 'doShowBgpPathSelectionSummary', arBgpModeOnly=True )
def handlerShowBgpPathSelectionSummary( mode, args ):
   cmd = ArBgpAsyncCliCommand( mode, 'show summary', vrfName=DEFAULT_VRF,
                               nlriAfiSafi='dps' )
   cmd.run()
   return cliPrinted( summaryVrfModel )

class BgpDpsCliHelperCommand( ArBgpCliCommand ):
   def __init__( self, mode, **kwargs ):
      self.mode = mode
      self.command = 'show bgp path-selection'
      self.model = kwargs.pop( 'model', None )

      ArBgpCliCommand.__init__( self, mode, self.command, vrfName=DEFAULT_VRF,
                                disableFork=True )

      if self.mode.session_.outputFormat_ == 'json':
         self.addParam( 'json' )

      for k, v in kwargs.items():
         if v:
            self.addParam( k, v )

   def run( self, **kwargs ):
      model = AgentCommandRequest.runCliPrintSocketCommand(
         self.entityManager,
         'BgpCliHelper',
         self.command,
         self.paramString(),
         self.mode,
         keepalive=True,
         connErrMsg='BgpCliHelper agent is inactive',
         model=self.model )
      return cliPrinted( model ) if model else None

@ArBgpShowOutput( '', arBgpModeOnly=True )
def handlerShowBgpPathSelection( mode, args ):
   return BgpDpsCliHelperCommand( mode,
                                  detail=args.get( 'detail' ),
                                  model=BgpDpsCliModels.BgpDpsRoutesVrfModel ).run()

@ArBgpShowOutput( '', arBgpModeOnly=True )
def handlerShowBgpNeighborPathSelection( mode, args ):
   peerAddr = { 'peerAddr': args.get( 'PEER' ) }
   convertPeerAddr( peerAddr )
   return BgpDpsCliHelperCommand(
      mode,
      detail=args.get( 'detail' ),
      peerAddr=peerAddr.get( 'peerAddr' ),
      routeType=args.get( 'ROUTE_TYPE' ),
      model=BgpDpsCliModels.BgpDpsRoutesVrfModel ).run()
