#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BgpLib import getVpwsName
import CliCommand
import CliPlugin.BgpMacVrfConfigCli as Globals
from CliPlugin.BgpMacVrfConfigCli import (
   BgpMacVrfStandAloneMode,
   BgpMacVrfVlanBundleMode,
   BgpMacVrfVniBundleMode,
   BgpMacVrfVpwsMode,
   BgpMacVrfVpwsPwConfigMode,
   getBundleName,
   getStandAloneName,
)

def BgpMacVrfBundleCommand_handler( mode, args ):
   bundleName = args[ 'NAME' ]
   macVrfName = getBundleName( Globals.MacVrfTypeEnum.macVrfTypeVlan, mode,
                               bundleName )
   childMode = mode.childMode( BgpMacVrfVlanBundleMode, macVrfName=macVrfName )
   mode.session_.gotoChildMode( childMode )

def BgpMacVrfBundleCommand_noOrDefaultHandler( mode, args ):
   bundleName = args[ 'NAME' ]
   macVrfName = getBundleName( Globals.MacVrfTypeEnum.macVrfTypeVlan, mode,
                               bundleName, validate=False )
   del Globals.bgpMacVrfConfigDir.config[ macVrfName ]

def BgpMacVrfStandAloneCommand_handler( mode, args ):
   vlanId = args[ 'VLAN_ID' ]
   macVrfName = getStandAloneName( vlanId )
   childMode = mode.childMode( BgpMacVrfStandAloneMode, macVrfName=macVrfName )
   mode.session_.gotoChildMode( childMode )

def BgpMacVrfStandAloneCommand_noOrDefaultHandler( mode, args ):
   vlanId = args[ 'VLAN_ID' ]
   macVrfName = getStandAloneName( vlanId )
   del Globals.bgpMacVrfConfigDir.config[ macVrfName ]

def BgpMacVrfVpwsCommand_handler( mode, args ):
   vpwsEviName = args[ 'VPWS' ]
   macVrfName = getVpwsName( vpwsEviName )
   childMode = mode.childMode( BgpMacVrfVpwsMode, macVrfName=macVrfName )
   mode.session_.gotoChildMode( childMode )

def BgpMacVrfVpwsCommand_noOrDefaultHandler( mode, args ):
   vpwsEviName = args[ 'VPWS' ]
   macVrfName = getVpwsName( vpwsEviName )
   del Globals.bgpMacVrfConfigDir.config[ macVrfName ]

def BgpMacVrfVpwsPwCommand_handler( mode, args ):
   pwName = args[ 'NAME' ]
   childMode = mode.childMode( BgpMacVrfVpwsPwConfigMode, pwName=pwName )
   mode.session_.gotoChildMode( childMode )

def BgpMacVrfVpwsPwCommand_noOrDefaultHandler( mode, args ):
   # NB: "mode" here is the parent mode, not the PW child mode
   pwName = args[ 'NAME' ]
   del mode.config().pseudowireConfig[ pwName ]

def BgpVniBundleCommand_handler( mode, args ):
   vnibundleName = args[ 'NAME' ]
   macVrfName = getBundleName( Globals.MacVrfTypeEnum.macVrfTypeVni, mode,
                               vnibundleName )
   prefix = Globals.macVrfPrefixDict[ Globals.MacVrfTypeEnum.macVrfTypeVni ]
   # Allow only one VNI bundle
   vniBundleExists = False
   macVrfs = Globals.bgpMacVrfConfigDir.config
   if macVrfs:
      if any( prefix in mv for mv in macVrfs ):
         bundle = [ b for b in macVrfs if prefix in b ]
         if bundle[ 0 ] != macVrfName:
            vniBundleExists = True
            # pylint: disable=consider-using-f-string
            err = 'Only one VNI bundle configuration allowed.\n' +\
                  'VNI-Aware-Bundle %s already exists' %\
                  list( Globals.bgpMacVrfConfigDir.config )[ 0 ].split( '.' )[ 1 ]
            mode.addError( err )

   if not vniBundleExists:
      childMode = mode.childMode( BgpMacVrfVniBundleMode, macVrfName=macVrfName )
      mode.session_.gotoChildMode( childMode )

def BgpVniBundleCommand_noOrDefaultHandler( mode, args ):
   vnibundleName = args[ 'NAME' ]
   macVrfName = getBundleName( Globals.MacVrfTypeEnum.macVrfTypeVni, mode,
                               vnibundleName, validate=False )
   del Globals.bgpMacVrfConfigDir.config[ macVrfName ]

def ElectionPreferenceRuleCommand_handler( mode, args ):
   mode.setPreferenceRule( args )

def ElectionPreferenceRuleCommand_noOrDefaultHandler( mode, args ):
   mode.noPreferenceRule( args )

def FxcSignalingCommand_handler( mode, args ):
   mode.setFxcSignaling( args )

def FxcSignalingCommand_noOrDefaultHandler( mode, args ):
   mode.noOrDefaultFxcSignaling( args )

def MacVrfMacAliasDefaultGateway_handler( mode, args ):
   mode.setMacAliasDefaultGateway()

def MacVrfMacAliasDefaultGateway_noOrDefaultHandler( mode, args ):
   mode.noMacAliasDefaultGateway()

def MacVrfRedistributeCommand_handlerCommon( fn, args ):
   valueDict = {
      'learned' : 'redistributeLearned',
      'static' : 'redistributeStatic',
      'router-mac' : 'redistributeRouterMac',
      'host-route' : 'redistributeHostRoute',
      'dot1x' : 'redistributeDot1x',
      'igmp' : 'redistributeIgmp',
      'mld' : 'redistributeMld',
      'link-local' : 'redistributeLinkLocal',
      'remote' : 'redistributeRemoteLearned',
      'primary' : 'redistributeRouterMacPrimary',
      'multicast-router' : 'redistributeMrouter',
   }
   for arg in args:
      if arg in valueDict:
         if arg == 'router-mac' and ( 'system' in args or 'next-hop' in args ):
            continue
         if arg == 'learned' and 'remote' in args:
            continue
         fn( valueDict[ arg ] )

def MacVrfRedistributeCommand_handler( mode, args ):
   MacVrfRedistributeCommand_handlerCommon( mode.setRedistribute, args )

def MacVrfRedistributeCommand_noOrDefaultHandler( mode, args ):
   if CliCommand.isNoCmd( args ):
      MacVrfRedistributeCommand_handlerCommon( mode.noRedistribute, args )
   elif CliCommand.isDefaultCmd( args ):
      MacVrfRedistributeCommand_handlerCommon( mode.defaultRedistribute, args )

def MacVrfRedistSysMacCommand_handler( mode, args ):
   mode.setRedistribute( 'redistributeSysMac' )
   if 'default-gateway' in args:
      mode.setRedistribute( 'redistributeSysMacGateway' )
   else:
      mode.noRedistribute( 'redistributeSysMacGateway' )

def MacVrfRedistSysMacCommand_noHandler( mode, args ):
   mode.noRedistribute( 'redistributeSysMac' )
   mode.noRedistribute( 'redistributeSysMacGateway' )

def MacVrfRedistSysMacCommand_defaultHandler( mode, args ):
   mode.defaultRedistribute( 'redistributeSysMac' )
   mode.defaultRedistribute( 'redistributeSysMacGateway' )

def MacVrfRedistRouterMacVirtualIpCommand_handler( mode, args ):
   if 'next-hop' in args and 'vtep' in args and 'primary' in args:
      mode.setRedistribute( 'redistributeRouterMacVirtualIpPrimary' )
   else:
      mode.noRedistribute( 'redistributeRouterMacVirtualIpPrimary' )
   mode.setRedistribute( 'redistributeRouterMacVirtualIp' )

def MacVrfRedistRouterMacVirtualIpCommand_noHandler( mode, args ):
   mode.noRedistribute( 'redistributeRouterMacVirtualIp' )
   mode.noRedistribute( 'redistributeRouterMacVirtualIpPrimary' )

def MacVrfRedistRouterMacVirtualIpCommand_defaultHandler( mode, args ):
   mode.defaultRedistribute( 'redistributeRouterMacVirtualIp' )
   mode.defaultRedistribute( 'redistributeRouterMacVirtualIpPrimary' )

def MacVrfRedistSysMacPrimaryIpCommand_handler( mode, args ):
   mode.setRedistribute( 'redistributeSysMacPrimaryIp' )

def MacVrfRedistSysMacPrimaryIpCommand_noOrDefaultHandler( mode, args ):
   mode.noRedistribute( 'redistributeSysMacPrimaryIp' )

def MaxRoutesCommand_handler( mode, args ):
   mode.setMaxRoutes( args )

def MaxRoutesCommand_noOrDefaultHandler( mode, args ):
   mode.noSetMaxRoutes( args )

def RdAutoCommand_handler( mode, args ):
   mode.setRouteDistinguisherAuto( args )

def RdAutoCommand_noOrDefaultHandler( mode, args ):
   mode.noRouteDistinguisher( args )

def RdCommand_handler( mode, args ):
   mode.setRouteDistinguisher( args )

def RdCommand_noOrDefaultHandler( mode, args ):
   mode.noRouteDistinguisher( args )

def RedistVxlanCommand_handler( mode, args ):
   mode.setRedistVxlan( args )

def RemoteRdCommand_handler( mode, args ):
   mode.setRemoteRouteDistinguisher( args )

def RemoteRdCommand_noOrDefaultHandler( mode, args ):
   mode.noRemoteRouteDistinguisher( args )

def RemoteRtCommand_handler( mode, args ):
   mode.handleRemoteDomainRt( args )

def RemoteRtCommand_noOrDefaultHandler( mode, args ):
   mode.noHandleRemoteDomainRt( args )

def RtAutoCommand_handler( mode, args ):
   mode.setRouteTargetImportExportAuto( args )

def RtAutoCommand_noOrDefaultHandler( mode, args ):
   mode.noRouteTargetImportExportAuto( args )

def RtCommand_handler( mode, args ):
   if 'import' in args and 'export' in args:
      mode.setRouteTargetConcatImportExport( args.get( 'RT' ) )
   else:
      for importExport in [ 'both', 'import', 'export' ]:
         if importExport in args:
            mode.setRouteTargetImportExport( importExport, args.get( 'RT' ) )
            return

def RtCommand_noOrDefaultHandler( mode, args ):
   if 'import' in args and 'export' in args:
      mode.noRouteTargetConcatImportExport( args.get( 'RT' ) )
   elif 'all' in args:
      mode.noRouteTargetAll()
   else:
      for importExport in [ 'both', 'import', 'export' ]:
         if importExport in args:
            mode.noRouteTargetImportExport( importExport, args.get( 'RT' ) )
            return

def UmrOriginateCommand_handler( mode, args ):
   mode.setUmrOriginator()

def UmrOriginateCommand_noOrDefaultHandler( mode, args ):
   mode.noUmrOriginator()

def VlanToEtidMapCommand_handler( mode, args ):
   mode.setVlanToEtidMap( args )

def VlanRangeCmd_handler( mode, args ):
   vlanSet = args.get( '<range>' )
   if args.get( "add" ):
      mode.addVlanRange( vlanSet )
   elif args.get( "remove" ):
      mode.removeVlanRange( vlanSet )
   else:
      mode.setVlanRange( vlanSet )

def VlanRangeCmd_noOrDefaultHandler( mode, args ):
   vlanSet = args.get( '<range>' )
   mode.noVlanRange( vlanSet )

def VpwsFlowLabelCommand_handler( mode, args ):
   mode.setFlowLabel( args )

def VpwsFlowLabelCommand_noOrDefaultHandler( mode, args ):
   mode.noFlowLabel( args )

def VpwsMplsControlWordCommand_handler( mode, args ):
   mode.setControlWord( args )

def VpwsMplsControlWordCommand_noOrDefaultHandler( mode, args ):
   mode.noControlWord( args )

def VpwsMtuCommand_handler( mode, args ):
   mode.setMtu( args )

def VpwsPwControlWordDataPlaneCmd_handler( mode, args ):
   direction = args[ 'DIRECTION' ]
   status = args[ 'STATUS' ]
   mode.setDataPlaneCw( direction, status )

def VpwsPwControlWordDataPlaneCmd_noOrDefaultHandler( mode, args ):
   direction = args.get( 'DIRECTION' )
   mode.noOrDefaultDataPlaneCw( direction=direction )

def VpwsPwColorCmd_handler( mode, args ):
   pwConfig = mode.config()
   pwConfig.color = args[ 'COLOR' ]
   mode.setConfig( pwConfig )

def VpwsPwColorCmd_noOrDefaultHandler( mode, args ):
   pwConfig = mode.config()
   pwConfig.color = None
   mode.setConfig( pwConfig )

def VpwsPwEvpnVpwsIdCommand_handler( mode, args ):
   mode.setVpwsId( args )

def VpwsPwEvpnVpwsIdCommand_noOrDefaultHandler( mode, args ):
   mode.noOrDefaultVpwsId( args )

def reviewVpwsRouteTargetRcfCommandArgs( mode, args ):
   if 'import' in args:
      mode.addError( 'The import option is not supported' )

def VpwsRouteTargetRcfCommand_handler( mode, args ):
   reviewVpwsRouteTargetRcfCommandArgs( mode, args )
   if mode.session.hasError():
      return
   rcfName = args[ 'FUNC_NAME' ].replace( '()', '' )
   if 'export' in args:
      mode.config().exportRtRcf = rcfName

def VpwsRouteTargetRcfCommand_noOrDefaultHandler( mode, args ):
   reviewVpwsRouteTargetRcfCommandArgs( mode, args )
   if mode.session.hasError():
      return
   if 'export' in args:
      mode.noRouteTargetExportRcf()
