#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BgpLib import NoOrDefault
import BmpUtils
from CliPlugin import (
   BmpCli,
   BmpRouterBgpBaseMode as Globals
)
from CliPlugin.IraServiceCli import getEffectiveProtocolModel
from CliPlugin.RoutingBgpCli import BgpCmdBaseClass
from IpLibTypes import ProtocolAgentModelType
from IpLibConsts import DEFAULT_VRF
import Tac

# Enum Type
TimestampMode = Tac.Type( 'Routing::Bmp::TimestampMode' )

def handlerMonitoringPortCmd( mode, args ):
   vrfName = DEFAULT_VRF
   Globals.bmpConfig.localPort[ vrfName ] = args[ 'PORT' ]

def noOrDefaultHandlerMonitoringPortCmd( mode, args ):
   vrfName = DEFAULT_VRF
   if vrfName in Globals.bmpConfig.localPort:
      del Globals.bmpConfig.localPort[ vrfName ]

def handlerMonitoringQosDscpCmd( mode, args ):
   Globals.bmpConfig.dscp = args[ 'DSCP_VALUE' ]

def noOrDefaultHandlerMonitoringQosDscpCmd( mode, args ):
   Globals.bmpConfig.dscp = Globals.bmpConfig.dscpDefault

def handlerMonitoringReceivedRoutesPostPolicyCmd( mode, args ):
   Globals.bmpConfig.ribInExportPolicyConfig = \
      BmpUtils.BmpRibInExportPolicyConfig(
         Globals.bmpConfig.ribInExportPolicyConfig.prePolicyExport, True )

def noHandlerMonitoringReceivedRoutesPostPolicyCmd( mode, args ):
   Globals.bmpConfig.ribInExportPolicyConfig = \
      BmpUtils.BmpRibInExportPolicyConfig(
         Globals.bmpConfig.ribInExportPolicyConfig.prePolicyExport, False )

def defaultHandlerMonitoringReceivedRoutesPostPolicyCmd( mode, args ):
   handlerMonitoringReceivedRoutesPostPolicyCmd( mode, args )

def handlerMonitoringReceivedRoutesPrePolicyCmd( mode, args ):
   Globals.bmpConfig.ribInExportPolicyConfig = \
      BmpUtils.BmpRibInExportPolicyConfig(
         True, Globals.bmpConfig.ribInExportPolicyConfig.postPolicyExport )

def noHandlerMonitoringReceivedRoutesPrePolicyCmd( mode, args ):
   Globals.bmpConfig.ribInExportPolicyConfig = \
      BmpUtils.BmpRibInExportPolicyConfig(
         False, Globals.bmpConfig.ribInExportPolicyConfig.postPolicyExport )

def defaultHandlerMonitoringReceivedRoutesPrePolicyCmd( mode, args ):
   handlerMonitoringReceivedRoutesPrePolicyCmd( mode, args )

def handlerMonitoringAdvertisedRoutesPostPolicyCmd( mode, args ):
   if getEffectiveProtocolModel( mode ) != ProtocolAgentModelType.multiAgent:
      mode.addWarning( "BGP advertised routes export is only supported in "
                       "multi-agent mode" )
   Globals.bmpConfig.ribOutExportPolicyConfig = \
      BmpUtils.BmpRibOutExportPolicyConfig( True )

def noHandlerMonitoringAdvertisedRoutesPostPolicyCmd( mode, args ):
   Globals.bmpConfig.ribOutExportPolicyConfig = \
      BmpUtils.BmpRibOutExportPolicyConfig( False )

def defaultHandlerMonitoringAdvertisedRoutesPostPolicyCmd( mode, args ):
   handlerMonitoringAdvertisedRoutesPostPolicyCmd( mode, args )

def handleNormalMonitoringBribRouteCmd( mode, args ):
   if getEffectiveProtocolModel( mode ) != ProtocolAgentModelType.multiAgent:
      mode.addWarning( "BGP RIB bestpaths monitoring is only supported in "
                       "multi-agent mode" )
   Globals.bmpConfig.locRibExportPolicyConfig = (
      BmpUtils.BmpLocRibExportPolicyConfig( True ) )

def handleNoOrDefaultMonitoringBribRouteCmd( mode, args, noOrDefault ):
   if noOrDefault == NoOrDefault.DEFAULT:
      Globals.bmpConfig.locRibExportPolicyConfig = (
         BmpUtils.BmpLocRibExportPolicyConfigUnset() )
   else:
      Globals.bmpConfig.locRibExportPolicyConfig = (
         BmpUtils.BmpLocRibExportPolicyConfig( False ) )

def handlerMonitoringBribRouteCmd( mode, args ):
   BgpCmdBaseClass.callHandler(
      handleNormalMonitoringBribRouteCmd,
      handleNoOrDefaultMonitoringBribRouteCmd,
      mode,
      args )

def noOrDefaultHandlerMonitoringBribRouteCmd( mode, args ):
   BgpCmdBaseClass.callNoOrDefaultHandler(
      handleNoOrDefaultMonitoringBribRouteCmd,
      mode,
      args )

def handlerMonitoringReceivedRoutesAfiSafiCmd( mode, args ):
   afiSafi = args[ 'AFISAFI' ]
   if 'disable' in args:
      Globals.bmpConfig.afiSafiExport[ afiSafi ] = False
   else:
      Globals.bmpConfig.afiSafiExport[ afiSafi ] = True
      if 'labeled-unicast' in args:
         Globals.bmpConfig.exportSixPe = '6pe' in args
         Globals.bmpConfig.exportIpv6LuTunnel = 'tunnel' in args

def noOrDefaultHandlerMonitoringReceivedRoutesAfiSafiCmd( mode, args ):
   afiSafi = args[ 'AFISAFI' ]
   del Globals.bmpConfig.afiSafiExport[ afiSafi ]
   if 'labeled-unicast' in args:
      Globals.bmpConfig.exportSixPe = False
      Globals.bmpConfig.exportIpv6LuTunnel = False

def handlerMonitoringStationBmpstationnameCmd( mode, args ):
   BmpCli.gotoBmpStationMode( mode, args[ 'BMPSTATIONNAME' ] )

def noOrDefaultHandlerMonitoringStationBmpstationnameCmd( mode, args ):
   BmpCli.deleteBmpStationMode( mode, args[ 'BMPSTATIONNAME' ] )

def handlerMonitoringTimestampCmd( mode, args ):
   if 'none' in args:
      Globals.bmpConfig.timestampMode = TimestampMode.none
   else:
      Globals.bmpConfig.timestampMode = TimestampMode.sendTime

def noOrDefaultHandlerMonitoringTimestampCmd( mode, args ):
   Globals.bmpConfig.timestampMode = Globals.bmpConfig.timestampModeDefault

def handlerMonitoringStatsIntervalCmd( mode, args ):
   Globals.bmpConfig.statsInterval = args[ 'STATSINTERVAL' ]

def noOrDefaultHandlerMonitoringStatsIntervalCmd( mode, args ):
   Globals.bmpConfig.statsInterval = Globals.bmpConfig.statsIntervalDefault
