# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import HttpService
from CliPlugin import AclCli
from CliDynamicSymbol import CliDynamicPlugin
import CliGlobal
import BasicCli
from CliMode.Capi import CapiVrfConfigModeBase
import CliCommand
import ConfigMount
import Tac

HttpServiceHandler = CliDynamicPlugin( "HttpServiceHandler" )

# -----------------------------------------------------------------------------------
# Mount path holders ( Define all mount path holders here )
# -----------------------------------------------------------------------------------
gv = CliGlobal.CliGlobal(
   dict(
      capiConfig=None,
   )
)

# -------------------------------------------------------------------------------
# The "[no | default] shutdown" command,
# in "vrf <vrf name>" mode
# under "management api http-commands" mode.
# -------------------------------------------------------------------------------
class CapiVrfConfigMode ( CapiVrfConfigModeBase, BasicCli.ConfigModeBase ):
   name = "Capi VRF configuration"

   def __init__( self, parent, session, vrfName ):
      CapiVrfConfigModeBase.__init__( self, ( vrfName, gv.capiConfig ) )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def shutdown( self ):
      HttpServiceHandler.removeVrfFromService( self.config_,
                                        'http-commands', self.vrfName_ )

   def noShutdown( self ):
      self.config().vrfService[ 'http-commands' ] = True

   def setServiceAcl( self, aclType, aclName ):
      key = Tac.Value( "Acl::AclTypeAndVrfName", aclType, self.vrfName_ )
      self.config_.serviceAclTypeVrfMap.aclName[ key ] = aclName

   def deleteServiceAcl( self, aclType ):
      key = Tac.Value( "Acl::AclTypeAndVrfName", aclType, self.vrfName_ )
      del self.config_.serviceAclTypeVrfMap.aclName[ key ]

class VrfModeShutdown( CliCommand.CliCommandClass ):
   syntax = '''shutdown'''
   noOrDefaultSyntax = '''shutdown ...'''
   data = { 'shutdown': HttpService.vrfShutdownHelpdesc }

   handler = "CapiHandler.vrfModeShutDownHandler"
   noHandler = "CapiHandler.vrfModeShutDownNoHandler"
   defaultHandler = handler

CapiVrfConfigMode.addCommandClass( VrfModeShutdown )

# -----------------------------------------------------------------------------
# The '[ no | default ] ip access-group <acl> [in]' command
# -----------------------------------------------------------------------------
class CapiIpAcl( CliCommand.CliCommandClass ):
   syntax = """ip access-group ACL_NAME [ in ]"""
   noOrDefaultSyntax = """ip access-group ..."""
   data = {
            'ip': AclCli.ipKwForServiceAclMatcher,
            'access-group': AclCli.accessGroupKwMatcher,
            'ACL_NAME': AclCli.ipAclNameMatcher,
            'in': AclCli.inKwMatcher
          }

   handler = "CapiHandler.capiIpAclHandler"
   noOrDefaultHandler = "CapiHandler.capiIpAclNoOrDefaultHandler"

CapiVrfConfigMode.addCommandClass( CapiIpAcl )

# -----------------------------------------------------------------------------
# The '[ no | default ] ipv6 access-group <acl> [in]' command
# -----------------------------------------------------------------------------
class CapiIpv6Acl( CliCommand.CliCommandClass ):
   syntax = """ipv6 access-group ACL_NAME [ in ]"""
   noOrDefaultSyntax = """ipv6 access-group ..."""
   data = {
            'ipv6': AclCli.ipv6KwMatcherForServiceAcl,
            'access-group': AclCli.accessGroupKwMatcher,
            'ACL_NAME': AclCli.ip6AclNameMatcher,
            'in': AclCli.inKwMatcher
          }

   handler = "CapiHandler.capiIpv6AclHandler"
   noOrDefaultHandler = "CapiHandler.capiIpv6AclNoOrDefaultHandler"

CapiVrfConfigMode.addCommandClass( CapiIpv6Acl )

# Plug-in definition:
def Plugin( entityManager ):
   gv.capiConfig = ConfigMount.mount( entityManager,
                                      "mgmt/capi/config",
                                      "HttpService::Config",
                                      "w" )
