# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Bool, Int, Model, List

class CliPid( Model ):
   pid = Int( help='PID of the current CLI' )

   def render( self ):
      print( 'CLI PID: %s' % self.pid ) # pylint: disable=consider-using-f-string

class PrivilegeLevel( Model ):
   privilegeLevel = Int( help="The current privilege level" )
   _secureMonitor = Bool( help="Secure-monitor user" )

   def render( self ):
      # pylint: disable-next=consider-using-f-string
      print( "Current privilege level is %d" % ( self.privilegeLevel ) )
      if self._secureMonitor:
         print( "* This is a secure-monitor session *" )

class ShowHistory( Model ):
   # BUG68678: Currently not ready for API consumption as the return
   # will always be an empty list, because history is integrated with
   # the readline history.
   __public__ = False
   historyItems = List( valueType=str,
                                 help="List of previously run CLI commands" )

   def render( self ):
      for i in self.historyItems:
         print( '  %s' % i ) # pylint: disable=consider-using-f-string
