# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliGlobal
import FileUrl
import LazyMount
import CliDynamicSymbol
import Url
import errno
from CliPlugin import ConfigTagCommon
from SectionCliLib import sectionFilter
import Tac

gv = CliGlobal.CliGlobal( dict( configTagStatus=None ) )
OperState = Tac.Type( "ConfigTag::ConfigTagState" )

def loadConfigTagCliModelsPlugin():
   return CliDynamicSymbol.loadDynamicPlugin( "ConfigTagCliModels" )

def createCommandTagStatusModel( mode, commandTagStatusEntry ):
   configTagCliModels = loadConfigTagCliModelsPlugin()
   commandTagStatusModel = configTagCliModels.CommandTagStatus()
   commandTagStatusModel.operState = commandTagStatusEntry.operState
   if commandTagStatusEntry.operState == OperState.disassociated:
      if ConfigTagCommon.checkTagInUse( mode, commandTagStatusEntry.tag ):
         commandTagStatusModel.operState = 'disassociating'
   elif commandTagStatusEntry.operState == OperState.removed:
      if ConfigTagCommon.checkTagInUse( mode, commandTagStatusEntry.tag ):
         commandTagStatusModel.operState = 'removing'
   return commandTagStatusModel

def showCommandTagHandler( mode, args ):
   configTagCliModels = loadConfigTagCliModelsPlugin()
   ret = configTagCliModels.CommandTags()
   commandTag = args.get( 'COMMAND_TAG', "" )
   statusEntry = gv.configTagStatus.configTagEntry.get( commandTag )
   if not commandTag:
      for tag, status in gv.configTagStatus.configTagEntry.items():
         ret.commandTags[ tag ] = createCommandTagStatusModel( mode, status )
   elif statusEntry:
      ret.commandTags[ commandTag ] = createCommandTagStatusModel( mode,
                                                                   statusEntry )
   return ret

def showRunningConfigCommandTagHandler( mode, args ):
   commandTag = args.get( 'COMMAND_TAG', None )
   if commandTag:
      regex = r'command-tag \b%s\b' % ( commandTag )
      commandTagStr = commandTag
   else:
      regex = r'command-tag'
      commandTagStr = '*'
   # We pass the command-tag string here so that individual savers can generate
   # only command-tag related config if required for performance, instead of
   # depending on the sectionFilter below to filter out command-tag config
   # using regex. If command-tag is not mentioned in the CLI, we pass '*',
   # a character that is not allowed in a command-tag, to denote generation of
   # config present for all command-tags.
   url = FileUrl.localRunningConfig( *Url.urlArgsFromMode( mode ),
                                     commandTag=commandTagStr )
   try:
      with url.open() as urlFd:
         sectionFilter( urlFd, [ regex ] )
   except OSError as e:
      if e.errno != errno.EPIPE:
         mode.addError( "Error displaying %s (%s)" % ( url.url, e.strerror ) )

def Plugin( em ):
   gv.configTagStatus = LazyMount.mount( em,
         'configTag/status', "ConfigTag::ConfigTagStatus", "r" )
