# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import TableOutput
from CliModel import Dict, Enum, Model

commandTagStates = ( "enabled", "disabled", "removed", "disassociated",
                     "disassociating", "removing" )

class CommandTagStatus( Model ):
   operState = Enum( values=commandTagStates, help='Command tag operational state' )

class CommandTags( Model ):
   commandTags = Dict( keyType=str, valueType=CommandTagStatus,
         help="A mapping of command tags with their current operational status" )

   def render( self ):
      headings = ( "Command Tag", "Operational State" )
      table = TableOutput.createTable( headings )
      fmt = TableOutput.Format( justify="left", wrap=True )
      fmt.noPadLeftIs( True )
      table.formatColumns( fmt, fmt )

      for commandTag, commandTagStatus in \
            sorted( self.commandTags.items() ):
         table.newRow( commandTag, commandTagStatus.operState )

      print( table.output() )
