# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.DaemonCli import DaemonCliMode


def doDaemonCliHelp_handler( mode, args ):
   print( r"""
Here you can implement debug cli commands to control/monitor an EosSdk agent.
Note: the real agent must have been "no shut" at some point in time for the
corresponding agent-specific Sysdb paths to have been created (else writting
to them will fail).
Also, ConfigAgent must have loaded the EosSdk mount points, which are not all
mounted by default (the route ones are because of the "show ip user route" cmd).
This is done by running this command from bash and then restarting ConfigAgent:

  for f in /usr/lib/SysdbMountProfiles/EosSdk_*.include; do          \\
    sudo bash -c "                                                   \\
      cat $f | sed 's/\/EosSdk-%sliceId\([, ]*[^,]*,\)/, Tac::Dir,/' \\
      | sed 's/\/%sliceId\([, ]*[^,]*,\)/, Tac::Dir,/'               \\
      > /usr/lib/SysdbMountProfiles/ConfigAgent_$(basename $f)       \\
    ";                                                               \\
  done;                                                              \\
  cat /usr/lib/SysdbMountProfiles/EosSdkAll                          \\
    | sed '1s/EosSdk.*/ConfigAgent/'                                 \\
    | sed 's/EosSdk_/ConfigAgent_EosSdk_/'                           \\
    > /usr/lib/SysdbMountProfiles/ConfigAgentEosSdkAll

  sudo killall -9 ConfigAgent

   """ )


def doDaemonCliCmd_handler( mode, args ):
   childMode = mode.childMode( DaemonCliMode, daemonName=mode.daemonName,
                               genCfg=mode.genericAgentCfg  )
   mode.session_.gotoChildMode( childMode )
