#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
from CliPlugin.DhcpServerCliSubmodeLib import (
   DhcpServerLeaseTimeBase,
   DhcpServerLeaseTimeExpression,
   DhcpServerTftpOption66Base,
   DhcpServerTftpOption150Base,
   DhcpServerTftpBootFileBase,
   DhcpServerV4DnsServer,
   DhcpServerV6DnsServer,
   DhcpServerPrivateOptionExpression,
   DhcpServerIpAddrPrivateOptionBase,
   DhcpServerV4DefaultGatewayBase,
   DhcpServerClientClassStringV4ArbitraryOption,
   DhcpServerClientClassIpAddrV4ArbitraryOption,
   DhcpServerClientClassFqdnV4ArbitraryOption,
   DhcpServerClientClassHexV4ArbitraryOption,
   DhcpServerClientClassStringV6ArbitraryOption,
   DhcpServerClientClassIpAddrV6ArbitraryOption,
   DhcpServerClientClassFqdnV6ArbitraryOption,
   DhcpServerClientClassHexV6ArbitraryOption,
   DhcpServerRangeClientClassIpAddrBase,
   generateTftpServerExpression,
   dhcpOptionExpressionData,
   IP_ADDRAdapter,
   IP6_ADDRAdapter,
   )
from CliPlugin import IpAddrMatcher
from CliPlugin import Ip6AddrMatcher
from CliMode.DhcpServer import (
   DhcpServerClientClassAssignBaseMode,
   DhcpServerSubnetClientClassAssignBaseMode,
   DhcpServerRangeClientClassAssignBaseMode,
   )
from EosDhcpServerLib import (
   featureFlexibleMatchingFuture,
   featureArbitraryOptionV6GlobalClientClass,
   featureArbitraryOptionV6SubnetClientClass,
   featureArbitraryOptionV6RangeClientClass,
   )

# maximum number of dns servers we allow
dnsHelp = "DHCP DNS configuration"
dnsServerHelp = 'Set the DNS server(s) for %s DHCP clients'

class DhcpServerClientClassLeaseTime( DhcpServerLeaseTimeBase ):
   data = {
      'lease': 'DHCP leases configuration',
      'time': 'Set the duration of the lease',
      'TIME': DhcpServerLeaseTimeExpression
   }

   handler = "DhcpServerCliHandler.setDhcpServerClientClassLeaseTime"

   noOrDefaultHandler = "DhcpServerCliHandler.noDhcpServerClientClassLeaseTime"

class DhcpServerSubnetClientClassLeaseTime( DhcpServerLeaseTimeBase ):
   data = {
      'lease': 'DHCP leases configuration',
      'time': 'Set the duration of the lease',
      'TIME': DhcpServerLeaseTimeExpression
   }

   handler = "DhcpServerCliHandler.setDhcpServerSubnetClientClassLeaseTime"

   noOrDefaultHandler = "DhcpServerCliHandler.noDhcpServerSubnetClientClassLeaseTime"

class DhcpServerRangeClientClassLeaseTime( DhcpServerLeaseTimeBase ):
   data = {
      'lease': 'DHCP leases configuration',
      'time': 'Set the duration of the lease',
      'TIME': DhcpServerLeaseTimeExpression
   }

   handler = "DhcpServerCliHandler.setDhcpServerRangeClientClassLeaseTime"

   noOrDefaultHandler = "DhcpServerCliHandler.noDhcpServerRangeClientClassLeaseTime"

class DhcpServerClientClassTftpOption66( DhcpServerTftpOption66Base ):
   data = {
      'TFTP_EXPR': generateTftpServerExpression( option="66" ),
      'NAME': CliMatcher.PatternMatcher( pattern=r'[a-zA-Z0-9\._-]+',
                                             helpname='SERVER',
                                             helpdesc='TFTP server name' ),
   }

   handler = "DhcpServerCliHandler.setDhcpServerClientClassTftpOption66"

   noOrDefaultHandler = handler

class DhcpServerClientClassTftpOption150( DhcpServerTftpOption150Base ):
   data = {
      'TFTP_EXPR': generateTftpServerExpression( option="150" ),
      'SERVER_ADDR': CliCommand.Node( matcher=IpAddrMatcher.ipAddrMatcher ),
   }

   handler = "DhcpServerCliHandler.setDhcpServerClientClassTftpOption150"

   noOrDefaultHandler = handler

class DhcpServerClientClassTftpBootFile( DhcpServerTftpBootFileBase ):
   data = {
      'TFTP_EXPR': generateTftpServerExpression(),
      'file': 'Set the boot file name',
      'FILENAME': CliMatcher.StringMatcher( helpname='FILENAME',
                                            helpdesc='TFTP boot file name' ),
   }

   handler = "DhcpServerCliHandler.setDhcpServerClientClassTftpBootFile"

   noOrDefaultHandler = handler

class DhcpServerClientClassPrivateOptionExpression(
                                       DhcpServerPrivateOptionExpression ):
   expression = 'private-option CODE [ always-send ] type'

class DhcpServerClientClassStringPrivateOption( CliCommand.CliCommandClass ):
   syntax = '''PRIVATE-OPTION string data STRING'''
   noOrDefaultSyntax = '''private-option CODE ...'''
   data = {
         'PRIVATE-OPTION': DhcpServerClientClassPrivateOptionExpression,
         'string': 'Type as string',
         'STRING': dhcpOptionExpressionData[ 'stringMatcherV4' ]
          }

   handler = "DhcpServerCliHandler.setDhcpServerClientClassStringPrivateOption"

   noOrDefaultHandler = ( "DhcpServerCliHandler."
                          "noDhcpServerClientClassStringPrivateOption" )

class DhcpServerClientClassIpv4AddrPrivateOption(
                           DhcpServerIpAddrPrivateOptionBase ):
   syntax = '''PRIVATE-OPTION ipv4-address data { IP_ADDR }'''
   data = {
         'PRIVATE-OPTION': DhcpServerClientClassPrivateOptionExpression,
         'ipv4-address': 'Type as IPv4 address',
         'IP_ADDR': CliCommand.Node( matcher=IpAddrMatcher.ipAddrMatcher ),
          }

   handler = "DhcpServerCliHandler.setDhcpServerClientClassIpv4AddrPrivateOption"

class DhcpServerClientClassIpv6AddrPrivateOption(
                           DhcpServerIpAddrPrivateOptionBase ):
   syntax = '''PRIVATE-OPTION ipv6-address data { IP6_ADDR }'''
   data = {
         'PRIVATE-OPTION': DhcpServerClientClassPrivateOptionExpression,
         'ipv6-address': 'Type as IPv6 address',
         'IP6_ADDR': CliCommand.Node( matcher=Ip6AddrMatcher.ip6AddrMatcher ),
          }

   handler = "DhcpServerCliHandler.setDhcpServerClientClassIpv6AddrPrivateOption"

class DhcpServerClientClassDnsDomainName( CliCommand.CliCommandClass ):
   syntax = '''dns domain name NAME'''
   noOrDefaultSyntax = '''dns domain name ...'''

   data = {
      'dns': dnsHelp,
      'domain': 'DHCP DNS domain configuration',
      'name': 'Set the domain name',
      'NAME': CliMatcher.PatternMatcher( r'.+',
                                         helpname='WORD',
                                         helpdesc='Domain name' )
   }

   handler = "DhcpServerCliHandler.setDhcpServerClientClassDnsDomainName"

   noOrDefaultHandler = "DhcpServerCliHandler.noDhcpServerClientClassDnsDomainName"

class DhcpServerClientClassV4DefaultGateway( DhcpServerV4DefaultGatewayBase ):
   data = {
         'default-gateway': 'Configure the client class\'s default gateway '
                            'sent to DHCP clients'
         }
   data.update( DhcpServerV4DefaultGatewayBase.data )

   handler = "DhcpServerCliHandler.setDhcpServerClientClassV4DefaultGateway"

   noOrDefaultHandler = handler

class DhcpServerRangeClientClassIpv4Addr( DhcpServerRangeClientClassIpAddrBase ):
   syntax = '''ipv4-address IP_ADDR'''
   noOrDefaultSyntax = '''ipv4-address ...'''

   data = {
         'ipv4-address': 'Reserve an IPv4 address',
         'IP_ADDR': IpAddrMatcher.IpAddrMatcher( 'IPv4 address' ),
         }

   adapter = IP_ADDRAdapter

   handler = "DhcpServerCliHandler.setDhcpServerRangeClientClassIpv4Addr"

   noOrDefaultHandler = handler

class DhcpServerRangeClientClassIpv6Addr( DhcpServerRangeClientClassIpAddrBase ):
   syntax = '''ipv6-address IP_ADDR'''
   noOrDefaultSyntax = '''ipv6-address ...'''

   data = {
         'ipv6-address': 'Reserve an IPv6 address',
         'IP_ADDR': Ip6AddrMatcher.Ip6AddrMatcher( 'IPv6 address' ),
         }

   adapter = IP6_ADDRAdapter

   handler = "DhcpServerCliHandler.setDhcpServerRangeClientClassIpv6Addr"

   noOrDefaultHandler = handler

# assignments mode
class DhcpServerClientClassAssignV4Mode( DhcpServerClientClassAssignBaseMode,
                                         BasicCli.ConfigModeBase ):
   name = "DHCP Server Client Class Ipv4 Assignments"

   def __init__( self, parent, session, clientClassName ):
      self.vrf = parent.vrf
      param = ( parent.clientClassConfig, clientClassName, self.vrf, 'ipv4' )
      DhcpServerClientClassAssignBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class DhcpServerClientClassAssignV6Mode( DhcpServerClientClassAssignBaseMode,
                                         BasicCli.ConfigModeBase ):
   name = "DHCP Server Client Class Ipv6 Assignments"

   def __init__( self, parent, session, clientClassName ):
      self.vrf = parent.vrf
      param = ( parent.clientClassConfig, clientClassName, self.vrf, 'ipv6' )
      DhcpServerClientClassAssignBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

# subnet client class assignments mode
class DhcpServerSubnetClientClassV4AssignMode(
      DhcpServerSubnetClientClassAssignBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Subnet Client Class Ipv4 Assignments"

   def __init__( self, parent, session, subnet, clientClassName ):
      self.vrf = parent.vrf
      param = ( subnet, parent.clientClassConfig, clientClassName,
                parent.vrf, 'ipv4' )
      DhcpServerSubnetClientClassAssignBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class DhcpServerSubnetClientClassV6AssignMode(
      DhcpServerSubnetClientClassAssignBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Subnet Client Class Ipv6 Assignments"

   def __init__( self, parent, session, subnet, clientClassName ):
      self.vrf = parent.vrf
      param = ( subnet, parent.clientClassConfig, clientClassName,
                parent.vrf, 'ipv6' )
      DhcpServerSubnetClientClassAssignBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

# range client class assignments mode
class DhcpServerRangeClientClassV4AssignMode(
      DhcpServerRangeClientClassAssignBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Range Client Class Ipv4 Assignments"

   def __init__( self, parent, session, subnet, subnetRange, clientClassName ):
      self.vrf = parent.vrf
      param = ( subnet, subnetRange, parent.clientClassConfig, clientClassName,
                parent.vrf, 'ipv4' )
      DhcpServerRangeClientClassAssignBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class DhcpServerRangeClientClassV6AssignMode(
      DhcpServerRangeClientClassAssignBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Range Client Class Ipv6 Assignments"

   def __init__( self, parent, session, subnet, subnetRange, clientClassName ):
      self.vrf = parent.vrf
      param = ( subnet, subnetRange, parent.clientClassConfig, clientClassName,
                self.vrf, 'ipv6' )
      DhcpServerRangeClientClassAssignBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

# add command
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerV4DnsServer )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassLeaseTime )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassTftpOption66 )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassTftpOption150 )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassTftpBootFile )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassStringPrivateOption )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassIpv4AddrPrivateOption )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassIpv4AddrPrivateOption )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassIpv4AddrPrivateOption )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassDnsDomainName )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassV4DefaultGateway )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassStringV4ArbitraryOption )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassIpAddrV4ArbitraryOption )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassFqdnV4ArbitraryOption )
DhcpServerClientClassAssignV4Mode.addCommandClass(
   DhcpServerClientClassHexV4ArbitraryOption )

if featureArbitraryOptionV6GlobalClientClass():
   DhcpServerClientClassAssignV6Mode.addCommandClass(
      DhcpServerClientClassStringV6ArbitraryOption )
   DhcpServerClientClassAssignV6Mode.addCommandClass(
      DhcpServerClientClassIpAddrV6ArbitraryOption )
   DhcpServerClientClassAssignV6Mode.addCommandClass(
      DhcpServerClientClassFqdnV6ArbitraryOption )
   DhcpServerClientClassAssignV6Mode.addCommandClass(
      DhcpServerClientClassHexV6ArbitraryOption )
   if featureArbitraryOptionV6SubnetClientClass():
      DhcpServerSubnetClientClassV6AssignMode.addCommandClass(
         DhcpServerClientClassStringV6ArbitraryOption )
      DhcpServerSubnetClientClassV6AssignMode.addCommandClass(
         DhcpServerClientClassIpAddrV6ArbitraryOption )
      DhcpServerSubnetClientClassV6AssignMode.addCommandClass(
         DhcpServerClientClassFqdnV6ArbitraryOption )
      DhcpServerSubnetClientClassV6AssignMode.addCommandClass(
         DhcpServerClientClassHexV6ArbitraryOption )
   if featureArbitraryOptionV6RangeClientClass():
      DhcpServerRangeClientClassV6AssignMode.addCommandClass(
         DhcpServerClientClassStringV6ArbitraryOption )
      DhcpServerRangeClientClassV6AssignMode.addCommandClass(
         DhcpServerClientClassIpAddrV6ArbitraryOption )
      DhcpServerRangeClientClassV6AssignMode.addCommandClass(
         DhcpServerClientClassFqdnV6ArbitraryOption )
      DhcpServerRangeClientClassV6AssignMode.addCommandClass(
         DhcpServerClientClassHexV6ArbitraryOption )

DhcpServerClientClassAssignV6Mode.addCommandClass(
   DhcpServerV6DnsServer )
DhcpServerClientClassAssignV6Mode.addCommandClass(
   DhcpServerClientClassLeaseTime )
DhcpServerClientClassAssignV6Mode.addCommandClass(
   DhcpServerClientClassTftpBootFile )
DhcpServerClientClassAssignV6Mode.addCommandClass(
   DhcpServerClientClassStringPrivateOption )
DhcpServerClientClassAssignV6Mode.addCommandClass(
   DhcpServerClientClassIpv6AddrPrivateOption )
DhcpServerClientClassAssignV6Mode.addCommandClass(
   DhcpServerClientClassDnsDomainName )

# subnet client assign commands
DhcpServerSubnetClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassV4DefaultGateway )
if featureFlexibleMatchingFuture():
   DhcpServerSubnetClientClassV4AssignMode.addCommandClass(
      DhcpServerSubnetClientClassLeaseTime )
   DhcpServerSubnetClientClassV6AssignMode.addCommandClass(
      DhcpServerSubnetClientClassLeaseTime )
DhcpServerSubnetClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassStringV4ArbitraryOption )
DhcpServerSubnetClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassIpAddrV4ArbitraryOption )
DhcpServerSubnetClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassFqdnV4ArbitraryOption )
DhcpServerSubnetClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassHexV4ArbitraryOption )

# range client assign commands
DhcpServerRangeClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassV4DefaultGateway )
if featureFlexibleMatchingFuture():
   DhcpServerRangeClientClassV4AssignMode.addCommandClass(
      DhcpServerRangeClientClassLeaseTime )
   DhcpServerRangeClientClassV6AssignMode.addCommandClass(
      DhcpServerRangeClientClassLeaseTime )
DhcpServerRangeClientClassV4AssignMode.addCommandClass(
      DhcpServerRangeClientClassIpv4Addr )

DhcpServerRangeClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassStringV4ArbitraryOption )
DhcpServerRangeClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassIpAddrV4ArbitraryOption )
DhcpServerRangeClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassFqdnV4ArbitraryOption )
DhcpServerRangeClientClassV4AssignMode.addCommandClass(
      DhcpServerClientClassHexV4ArbitraryOption )

DhcpServerRangeClientClassV6AssignMode.addCommandClass(
      DhcpServerRangeClientClassIpv6Addr )
