#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliPlugin.DhcpServerCliSubmodeLib import (
   DhcpServerClientClassMatchMacAddr,
   DhcpServerClientClassMatchVendorId,
   DhcpServerClientClassMatchAristaInfoOption,
   DhcpServerClientClassMatchInfoOptionHexOrStr,
   DhcpServerClientClassMatchDuid,
   DhcpServerClientClassMatchVendorClass,
   DhcpServerClientClassMatchAristaRemoteId,
   DhcpServerClientClassMatchRemoteIdHexOrStr,
   )
from CliMode.DhcpServer import (
   DhcpServerClientClassNestedMatchBaseMode,
   DhcpServerSubnetClientClassNestedMatchBaseMode,
   DhcpServerRangeClientClassNestedMatchBaseMode,
   )

class DhcpServerClientClassV4NestedMatchMode(
      DhcpServerClientClassNestedMatchBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Client Class V4 Match"

   def __init__( self, parent, session, clientClassName, matchAny, matchName ):
      self.vrf = parent.vrf
      param = ( clientClassName, matchAny, matchName, self.vrf, 'ipv4' )
      DhcpServerClientClassNestedMatchBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class DhcpServerClientClassV6NestedMatchMode(
      DhcpServerClientClassNestedMatchBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Client Class V6 Match"

   def __init__( self, parent, session, clientClassName, matchAny, matchName ):
      self.vrf = parent.vrf
      param = ( clientClassName, matchAny, matchName, self.vrf, 'ipv6' )
      DhcpServerClientClassNestedMatchBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class DhcpServerSubnetClientClassV4NestedMatchMode(
      DhcpServerSubnetClientClassNestedMatchBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Subnet Client Class V4 Match"

   def __init__( self, parent, session, subnetPrefix, clientClassName, matchAny,
                 matchName ):
      self.vrf = parent.vrf
      param = ( subnetPrefix, clientClassName, matchAny, matchName,
                self.vrf, 'ipv4' )
      DhcpServerSubnetClientClassNestedMatchBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class DhcpServerSubnetClientClassV6NestedMatchMode(
      DhcpServerSubnetClientClassNestedMatchBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Subnet Client Class V6 Match"

   def __init__( self, parent, session, subnetPrefix, clientClassName, matchAny,
                 matchName ):
      self.vrf = parent.vrf
      param = ( subnetPrefix, clientClassName, matchAny, matchName,
                self.vrf, 'ipv6' )
      DhcpServerSubnetClientClassNestedMatchBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class DhcpServerRangeClientClassV4NestedMatchMode(
      DhcpServerRangeClientClassNestedMatchBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Range Client Class V4 Match"

   def __init__( self, parent, session, subnetConfig, rangeConfig, clientClassName,
                 matchAny, matchName ):
      self.vrf = parent.vrf
      param = ( subnetConfig, rangeConfig, clientClassName,
                matchAny, matchName, self.vrf, 'ipv4' )
      DhcpServerRangeClientClassNestedMatchBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class DhcpServerRangeClientClassV6NestedMatchMode(
      DhcpServerRangeClientClassNestedMatchBaseMode, BasicCli.ConfigModeBase ):
   name = "DHCP Server Range Client Class V6 Match"

   def __init__( self, parent, session, subnetConfig, rangeConfig, clientClassName,
                 matchAny, matchName ):
      self.vrf = parent.vrf
      param = ( subnetConfig, rangeConfig, clientClassName,
                matchAny, matchName, self.vrf, 'ipv6' )
      DhcpServerRangeClientClassNestedMatchBaseMode.__init__( self, param )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

# add command
DhcpServerClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchMacAddr )
DhcpServerClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchVendorId )
DhcpServerClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchAristaInfoOption )
DhcpServerClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchInfoOptionHexOrStr )

DhcpServerSubnetClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchMacAddr )
DhcpServerSubnetClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchVendorId )
DhcpServerSubnetClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchAristaInfoOption )
DhcpServerSubnetClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchInfoOptionHexOrStr )

DhcpServerRangeClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchMacAddr )
DhcpServerRangeClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchVendorId )
DhcpServerRangeClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchAristaInfoOption )
DhcpServerRangeClientClassV4NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchInfoOptionHexOrStr )

# v6 command
DhcpServerClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchMacAddr )
DhcpServerClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchDuid )
DhcpServerClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchVendorClass )
DhcpServerClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchAristaRemoteId )
DhcpServerClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchRemoteIdHexOrStr )

DhcpServerSubnetClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchMacAddr )
DhcpServerSubnetClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchDuid )
DhcpServerSubnetClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchVendorClass )
DhcpServerSubnetClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchAristaRemoteId )
DhcpServerSubnetClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchRemoteIdHexOrStr )

DhcpServerRangeClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchMacAddr )
DhcpServerRangeClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchDuid )
DhcpServerRangeClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchVendorClass )
DhcpServerRangeClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchAristaRemoteId )
DhcpServerRangeClientClassV6NestedMatchMode.addCommandClass(
   DhcpServerClientClassMatchRemoteIdHexOrStr )
