# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
from CliMode.Email import EmailMode
from CliPlugin.VrfCli import VrfExprFactory

emailConfig = None

matcherAuth = CliMatcher.KeywordMatcher( 'auth',
      helpdesc='Email account authentication' )

# --------------------------------------------------------------------------
# The email mode
# --------------------------------------------------------------------------
class EmailConfigMode( EmailMode, BasicCli.ConfigModeBase ):
   name = "Email configuration"

   def __init__( self, parent, session ):
      EmailMode.__init__( self, param = " " )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

# --------------------------------------------------------------------------
# The "[no|default] server [ vrf VRF ] SERVER" command, in email mode.
# --------------------------------------------------------------------------
class ServerCmd( CliCommand.CliCommandClass ):
   syntax = 'server [ VRF ] SERVER'
   noOrDefaultSyntax = 'server ...'
   data = {
      'server': 'Email relay',
      'VRF': VrfExprFactory( helpdesc='Use a specific VRF' ),
      'SERVER': CliMatcher.PatternMatcher( pattern=r'[^\s:]+(?::\d+)?',
                                           partialPattern=r'[^\s:]*(?::\d*)?',
                                           helpdesc='E-Mail server / relay',
                                           helpname='HOST:PORT' ),
   }

   handler = "EmailCliHandler.setServer"
   noOrDefaultHandler = "EmailCliHandler.noServer"

EmailConfigMode.addCommandClass( ServerCmd )

# --------------------------------------------------------------------------
# The "[no|default] from-user EMAIL_ADDRESS" command, in email mode.
# --------------------------------------------------------------------------
class FromUserCmd( CliCommand.CliCommandClass ):
   syntax = 'from-user EMAIL_ADDRESS'
   noOrDefaultSyntax = 'from-user ...'
   data = {
      'from-user': 'Send email from this user',
      'EMAIL_ADDRESS': CliMatcher.PatternMatcher( pattern=r'\S+',
                                    helpdesc='E-Mail address', helpname='WORD' ),
   }

   handler = "EmailCliHandler.setFromUser"
   noOrDefaultHandler = "EmailCliHandler.noFromUser"

EmailConfigMode.addCommandClass( FromUserCmd )

# --------------------------------------------------------------------------
# The "[no|default] auth username USERNAME" command, in email mode.
# --------------------------------------------------------------------------
class AuthUsernameCmd( CliCommand.CliCommandClass ):
   syntax = 'auth username USERNAME'
   noOrDefaultSyntax = 'auth username ...'
   data = {
      'auth': 'Email account authentication',
      'username': 'Email login username',
      'USERNAME': CliMatcher.PatternMatcher( pattern=r'\S+',
                           helpdesc='Account name string', helpname='WORD' ),
   }
   handler = "EmailCliHandler.setUser"
   noOrDefaultHandler = "EmailCliHandler.noUser"

EmailConfigMode.addCommandClass( AuthUsernameCmd )

# --------------------------------------------------------------------------
# The "[no] auth password [0 | 7] PASSWORD" command, in email mode.
# --------------------------------------------------------------------------
class AuthPasswordCmd( CliCommand.CliCommandClass ):
   syntax = 'auth password [ 0 | 7 ] PASSWORD'
   noOrDefaultSyntax = 'auth password ...'
   data = {
      'auth': matcherAuth,
      'password': 'Email login password',
      '0': CliMatcher.KeywordMatcher( '0', helpdesc='No encryption' ),
      '7': CliMatcher.KeywordMatcher( '7', helpdesc='Symmetric encryption' ),
      'PASSWORD': CliCommand.Node(
                  matcher=CliMatcher.PatternMatcher( pattern=r'\S+',
                  helpdesc='Password', helpname='WORD' ), sensitive=True ),
   }
   handler = "EmailCliHandler.setPassword"
   noOrDefaultHandler = "EmailCliHandler.noPassword"

EmailConfigMode.addCommandClass( AuthPasswordCmd )

# --------------------------------------------------------------------------
# The "[no|default] tls" command, in email mode.
# --------------------------------------------------------------------------

class TlsCmd( CliCommand.CliCommandClass ):
   syntax = 'tls'
   noOrDefaultSyntax = syntax
   data = {
      'tls': 'Require TLS',
   }
   handler = "EmailCliHandler.setTls"
   noOrDefaultHandler = "EmailCliHandler.noTls"

EmailConfigMode.addCommandClass( TlsCmd )
