# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicPlugin.EosLabEtbaModel import (
      EosLabKernelInterfaceSortingInfo,
      EosLabKernelInterfacePath,
      EosLabKernelInterfaceOffload,
      )
import Tac
import Tracing

import os

t0 = Tracing.trace0

sysClassNet = '/sys/class/net'

# The code in allDeviceNames() to read sysClassnet, and in
# showEosLabKernelInterfacePath() to read the acpi_index,
# is similar to the FruPlugin/GenericPc.py sortKernelDevices.
# If something about these functions starts behaving differently
# than expected, check GenericPc.py for changes to copy.

def allDeviceNames():
   goodDevices = []
   for devName in os.listdir( sysClassNet ):
      if not os.path.isdir( os.path.join( sysClassNet, devName ) ):
         # Possibly a file, like "bonding_masters".
         continue
      goodDevices.append( devName )
   return goodDevices

def showEosLabKernelInterfacePath( mode, args ):
   devMap = EosLabKernelInterfacePath()
   for devName in allDeviceNames():
      t0( 'looking at', devName )
      path = os.path.realpath(
                   os.path.join( sysClassNet, devName, "device" ) )
      addr = path.replace( "/sys/devices/", "" )
      t0( 'addr for', devName, 'is', addr )
      acpiIndex = None
      try:
         with open( os.path.join( path, "acpi_index" ) ) as f:
            acpiIndex = int( f.read() )
      except OSError:
         # no acpi_index file
         pass
      devMap.devices[ devName ] = EosLabKernelInterfaceSortingInfo( path=addr,
                                                               acpiIndex=acpiIndex )

   return devMap

def showEosLabKernelInterfaceOffload( mode, args ):
   offloadMap = EosLabKernelInterfaceOffload()
   for devName in allDeviceNames():
      t0( 'looking at', devName )
      offload = Tac.run( [ 'ethtool', '-k', devName ],
            stdout=Tac.CAPTURE, stderr=Tac.CAPTURE,
            ignoreReturnCode=True )
      t0( 'offload for', devName, 'is', offload )
      offloadMap.devices[ devName ] = offload
   t0( offloadMap )

   return offloadMap
