# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import eossdk

# ############################################################################
# ################# Cli_Command_Handlers #####################################
# ############################################################################


def doRouteShow_handler(self, args):
   tag = args.get('TAG_NUM', 0)
   numRoutes = 0
   totalRoutes = 0
   lock = eossdk.SdkScopedLock()
   routeFmt = "{} [preference {}, tag {}] has nexthops:"
   for route in self.ipRouteMgr.ip_route_iter():
      totalRoutes += 1
      if not tag or route.tag == tag:
         numRoutes += 1
         # Print the route line
         print( routeFmt.format(route.key().prefix().to_string(),
                                route.key().preference(), route.tag() ) )

         # And now print all the vias for this route
         seen_vias = False
         for via in self.ipRouteMgr.ip_route_via_iter(route.key()):
            seen_vias = True
            # Only print out the relevant via information
            if via.hop() != eossdk.IpAddr():
               output = "Nexthop " + via.hop().to_string()
            elif via.intf() != eossdk.IntfId():
               if via.intf().is_null0():
                  output = "Drop route"
               else:
                  output = "Interface " + via.intf.to_string
            elif via.nexthop_group():
               output = "Nexthop group " + via.nexthop_group()
            else:
               output = "Unknown via type"

            if via.mpls_label() != eossdk.MplsLabel():
               output = " and push MPLS Label " + via.mpls_label().to_string()
            print( "      -", output )

         if not seen_vias:
            print( "      - no nexthops!" )

   del lock

   # Print a nice footer
   print()
   print( "Saw", numRoutes, "matching routes out of", totalRoutes, "total routes" )
   print()


def doRouteDel_handler( self, args ):
   target = args[ '<target>' ]
   gateway = args.get( '<gateway>' )
   print( "route del", target, gateway )

   def buildRoute( ipAddr ):
      ip_prefix = eossdk.IpPrefix( ipAddr )
      ip_route_key = eossdk.IpRouteKey( ip_prefix )
      return eossdk.IpRoute( ip_route_key )

   def buildVia( routeKey, hop ):
      route_via = eossdk.IpRouteVia( routeKey )
      route_via.hop_is( eossdk.IpAddr( hop ) )
      route_via.intf_is( eossdk.IntfId( 'Ethernet1' ) )
      return route_via

   route = buildRoute( target )
   if gateway:
      routeVia = buildVia( route.key(), gateway )
      self.ipRouteMgr.ip_route_via_del( routeVia )
      return
   self.ipRouteMgr.ip_route_del( route.key() )


def doRouteAdd_handler( self, args ):
   target = args[ '<target>' ]
   gateway = args[ '<gateway>' ]

   def buildRoute( ipAddr ):
      ip_prefix = eossdk.IpPrefix( ipAddr )
      ip_route_key = eossdk.IpRouteKey( ip_prefix )
      return eossdk.IpRoute( ip_route_key )

   def buildVia( routeKey, hop ):
      route_via = eossdk.IpRouteVia( routeKey )
      route_via.hop_is( eossdk.IpAddr( hop ) )
      route_via.intf_is( eossdk.IntfId( 'Ethernet1' ) )
      return route_via

   route = buildRoute( target )
   self.ipRouteMgr.ip_route_set( route )
   route.tag_is( 1 )
   self.ipRouteMgr.ip_route_set( route )
   self.ipRouteMgr.ip_route_set( route, eossdk.IP_ROUTE_ACTION_NEXTHOP_GROUP )
   routeVia = buildVia( route.key(), gateway )
   self.ipRouteMgr.ip_route_via_set( routeVia )
