# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AclCliLib
import ConfigMount
from socket import IPPROTO_TCP

aclConfig = None
aclCpConfig = None

def noServiceAcl( mode, service, serverConfig, aclType="ip" ):
   AclCliLib.noServiceAcl( mode, service, aclConfig, aclCpConfig,
      None, aclType, serverConfig.vrfName )

def setServiceAcl( mode, service, serverConfig, aclType="ip" ):
   AclCliLib.setServiceAcl( mode, service, IPPROTO_TCP, aclConfig, aclCpConfig,
      serverConfig.serviceAcl, aclType, serverConfig.vrfName,
      port=[ serverConfig.localInterface.port ] )

def existsOtherTransportSameVrfWithServiceAcl( mode, serverConfigDir, vrfName=None ):
   if not vrfName:
      vrfName = mode.serverConfig.vrfName
   for serverConfig in serverConfigDir.values():
      if vrfName == serverConfig.vrfName and serverConfig.serviceAcl:
         mode.addError( f"transport '{serverConfig.name}' in VRF "
                        f"{serverConfig.vrfName} already configured with "
                        f"service ACL '{serverConfig.serviceAcl}'; "
                        "only one transport in the same VRF "
                        "can be configured with a service ACL; all transports "
                        "in the same VRF use the same service ACL" )
         return True
   return False

def Plugin( entityManager ):
   global aclConfig, aclCpConfig

   aclConfig = ConfigMount.mount( entityManager,
                                "acl/config/cli",
                                "Acl::Input::Config",
                                "w" )
   aclCpConfig = ConfigMount.mount( entityManager,
                                    "acl/cpconfig/cli",
                                    "Acl::Input::CpConfig",
                                    "w" )
