#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import InotifyQuery
from CliPlugin.InotifyModel import ALL_QUERIES
from CliDynamicSymbol import CliDynamicPlugin
import os

queryLib = InotifyQuery.InotifyQueryLib()
InotifyModel = CliDynamicPlugin( "InotifyModel" )

def checkIsRootWarning( mode ):
   if os.geteuid():
      mode.addWarning( 'Output may not be complete without root access.' )

def _convertPidsModel( inotifyPids ):
   # Convert InotifyQuery.InotifyPids model to InotifyModel.InotifyPids
   pids = {}
   for pid, pidObj in inotifyPids.pids.items():
      fds = {}
      for fd, filesObj in pidObj.fds.items():
         fileList = []
         for fileObj in filesObj.fileList:
            fileList.append( InotifyModel.InotifyFile(
               filepath=fileObj.filepath,
               watchDescriptor=fileObj.wd ) )
         fds[ fd ] = InotifyModel.InotifyFiles( files=fileList )

      pids[ pid ] = InotifyModel.InotifyPid(
            cmdline=pidObj.cmdline, fds=fds )
   return InotifyModel.InotifyPids( pids=pids )

def InotifyShowFilesCmdHandler( mode, args ):
   checkIsRootWarning( mode )
   pid = args[ "PID" ]

   model = InotifyModel.InotifyQueryFilesModel( _pid=pid, files=[] )
   query = queryLib.file( pid )
   for fileObj in query.fileList:
      model.files.append( InotifyModel.InotifyFile(
         filepath=fileObj.filepath, watchDescriptor=fileObj.wd ) )

   return model

def InotifyShowCmdHandler( mode, args ):
   checkIsRootWarning( mode )
   queryString = args.get( 'QUERY', 'all' )
   queries = ALL_QUERIES if queryString == 'all' else [ queryString ]
   queryModel = InotifyModel.InotifyQueryModel( _query=queryString,
                                                count=None, limits=None, ps=None,
                                                user=None, watch=None )

   for query in queries:
      result = getattr( queryLib, query )()
      if query == 'count':
         queryModel.count = result.count
      elif query == 'limits':
         queryModel.limits = result.limits
      elif query == 'ps':
         cliProcInfo = {}
         for proc, info in result.ps.items():
            cliProcInfo[ proc ] = \
               InotifyModel.InotifyProc( count=info.count, cmdline=info.cmdline )
         queryModel.ps = cliProcInfo
      elif query == 'user':
         cliUserInfo = {}
         for uid, info in result.users.items():
            cliUserInfo[ uid ] = \
               InotifyModel.InotifyProc( count=info.count, owner=info.owner )
         queryModel.user = cliUserInfo
      elif query == 'watch':
         queryModel.watch = _convertPidsModel( result )
   return queryModel
