#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AgentCommandRequest import runCliPrintSocketCommand
import Ipv6RouterAdvtAgent
from CliModel import cliPrinted
from CliDynamicSymbol import CliDynamicPlugin
import ConfigMount
import LazyMount
import Ipv6RouterAdvtLib

routerAdvtConfig = None
routerAdvtStatus = None
Ip6RaCliModels = CliDynamicPlugin( "Ip6RaCliModels" )

# --------------------------------------------------------------------------------
# show ipv6 nd ra internal state [ VRF | INTF ]
# --------------------------------------------------------------------------------
def showIpv6NdRaInternalStateCmd( mode, args ):
   if not routerAdvtStatus.routerAdvtDaemonActive:
      return Ip6RaCliModels.RaNdInternalStates( vrfs={}, interfaces={} )

   cmd = ''
   if intf := args.get( 'INTF' ):
      cmd += f' INTF={intf}'
   elif vrf := args.get( 'VRF' ):
      cmd += f' VRF={vrf}'
   model = runCliPrintSocketCommand( mode.entityManager,
                                     Ipv6RouterAdvtAgent.name,
                                     "show-internal-state",
                                     cmd,
                                     mode=mode,
                                     keepalive=True,
                                     model=Ip6RaCliModels.RaNdInternalStates )
   return cliPrinted( model ) if model else None

def configRaPref64Option( mode, args ):
   ip6Prefix = args[ 'IP6PREFIX' ]
   if ip6Prefix is None:
      mode.addError( "Host part of prefix must be zero" )
      return
   ip6NdIntfConf = Ipv6RouterAdvtLib.Ip6NdIntfConfig( routerAdvtConfig,
                                                      mode.intf.name )
   lifetime = args.get( 'LIFETIME' )
   ip6NdIntfConf.ndRaPref64Option( ip6Prefix, lifetime )

def configNoRaPref64Option( mode, args ):
   ip6NdIntfConf = Ipv6RouterAdvtLib.Ip6NdIntfConfig( routerAdvtConfig,
                                                      mode.intf.name )
   ip6NdIntfConf.noNdRaPref64Option()

def Plugin( em ):
   global routerAdvtConfig, routerAdvtStatus
   routerAdvtConfig = ConfigMount.mount( em, "routing6/routerAdvt/config",
                                         "RouterAdvt::Config", "w" )
   routerAdvtStatus = LazyMount.mount( em, "routing6/routerAdvt/status",
                                       "RouterAdvt::Status", "r" )
