#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import (
   Int,
   Model,
   Dict,
   Float,
   Str,
   Bool
)

class VrfGlobalCounters( Model ):
   __revision__ = 2
   ipv6UnicastRouting = Bool( help="IPv6 unicast routing is enabled" )
   numPktDroppedIntfStateNotFound = Int( help="Number of packets dropped due "
                                              "to interface state not found" )
   numRsDroppedInvalidHopLimit = Int( help="Number of routes dropped due "
                                           "to invalid hop limit" )
   numPktDroppedUnexpectedType = Int( help="Number of packets dropped due to "
                                           "unexpected type" )
   numRecvMsgErrors = Int( help="Number of received message errors" )
   numCmsgDataErrors = Int( help="Number of Cmessage data errors" )

class Interface( Model ):
   vrf = Str( help="VRF name" )
   intfIndex = Int( help="Interface index" )
   mtu = Int( help="Interface status MTU" )
   numIpv6Addr = Int( help="Number of IPv6 interfaces" )
   numPrefixToAdvertise = Int( help="Number of prefixes to advertise" )
   numPrefixToSuppress = Int( help="Number of prefixes to suppress" )
   raSuppress = Bool( help="Router advertisements are suppressed" )
   rsRspSuppress = Bool( help="Router solicitation responses are suppressed" )
   raIntervalMaxMsec = Int( help="Router advertisements maximum "
                                 "interval (milliseconds)" )
   raIntervalMinMsec = Int( help="Route advertisements minimum "
                                 "interval (milliseconds)" )
   managedConfigFlag = Bool( help="Managed address configuration flag is set" )
   otherConfigFlag = Bool( help="Other stateful configuration flag is set" )
   raMtuSuppress = Bool( help="Suppress IPv6 RA MTU option is set" )
   raLifetime = Int( help="Router lifetime value in router advertisements" )
   reachableTime = Int( help="The amount of time that a remote IPv6 node is "
                             "considered reachable" )
   hopLimit = Int( help="Router advertisements hop limit value" )
   nsRetransmitInterval = Int( help="Time between neighbor solicitation "
                                    "retransmissions" )
   numDnsServers = Int( help="Number of DNS servers" )
   dnsServersLifetime = Int( help="DNS servers lifetime (seconds)" )
   numDnsSuffixes = Int( help="Number of DNS domain name suffixes" )
   dnsSuffixesLifetime = Int( help="DNS suffixes lifetime (seconds)" )
   routerPreference = Int( help="Router preference type" )
   lastRaTime = Float( help="Last router advertisement sent time (epoch)" )
   lastRsRspSentTime = Float( help="Last router solicitation response time (epoch)" )
   nextTimeout = Float( help="Next timeout (seconds)" )
   raNotSentIntfNotReady = Bool( help="No router advertisements sent on "
                                      "this interface" )
   numRaSent = Int( help="Number of route advertisements sent" )
   numRaRcvd = Int( help="Number of route advertisements received" )
   numRaRcvdConsistent = Int( help="Number of consistent route advertisements "
                                   "received" )
   numRaRcvdInconsistent = Int( help="Number of inconsistent route advertisements "
                                     "received" )
   numRsRcvd = Int( help="Number of router solicitation requests received" )
   numRsSuppressed = Int( help="Number of router solicitation requests received "
                               "with the response suppressed" )
   numRsRspSent = Int( help="Number of router solicitation responses sent" )
   numRsDroppedInvalidHopLimit = Int( help="Number of router solicitation requests "
                                           "droppped as the hoplimit is less "
                                           "than 255." )
   numPktDroppedUnexpectedType = Int( help="Number of packets dropped due "
                                           "to unexpected type" )
   initialized = Bool( help="Interface SM is initialized" )

class RaNdInternalStates( Model ):
   __revision__ = 2
   vrfs = Dict( valueType=VrfGlobalCounters,
                help="A mapping of VRF name to global counter information" )
   interfaces = Dict( valueType=Interface,
                      help="A mapping of interface ID to interface information" )
