# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.RoutingIsisCli import (
      getHostName,
)
from CliPlugin.IsisCliModels import (
                                     setSrv6LocatorFlags,
                                     getRouterId,
                                     Srv6LocatorFlags
)
from CliPlugin import IsisSrv6ShowCliModel
import CliPlugin.IsisSrv6ShowCli
from Toggles import gatedToggleLib
import SharkLazyMount
import Arnet

from IsisShowLib import getIsisConfigAndStatus
from IsisShowLib import isisSrv6IsActive
from IsisShowLib import showIsisCommand

isisSrv6Shark = None

if gatedToggleLib.toggleIsisSrv6Enabled():
   isisSrv6Shark = CliPlugin.IsisSrv6ShowCli.gv.isisSrv6Shark

def _getIsisSrv6ConfigAndStatus( mode, instanceId, instanceName ):
   instConfig, instStatus = getIsisConfigAndStatus( mode, instanceId,
                                                    instanceName )
   if instConfig and instStatus:
      if not isisSrv6IsActive(mode, instanceName ):
         return None, None
   return instConfig, instStatus

def _populateLocatorInstancesModel( locator, locatorKey ):
   for nodeKey, locatorInfo in locator.locatorInfo.items():
      locInstModel = IsisSrv6ShowCliModel.IsisSrv6LocatorInstance()
      locInstModel.algorithm = locatorKey.algo
      locInstModel.systemId = str( nodeKey.sysId )
      locInstModel.hostName = getHostName( getRouterId( locInstModel.systemId ) )
      locInstModel.metric = locatorInfo.metric
      locInstModel.flags = Srv6LocatorFlags()
      setSrv6LocatorFlags( locInstModel.flags, locatorInfo.flags )
      yield locInstModel

def _populateLocatorModel( levelInfo ):
   for locatorKey, locator in levelInfo.locator.items():
      locatorModel = IsisSrv6ShowCliModel.IsisSrv6Locator()
      prefix = Arnet.IpGenPrefix( locatorKey.prefix.stringValue )
      locatorModel.locatorInstances = _populateLocatorInstancesModel( locator,
                                                            locatorKey )
      yield prefix, locatorModel

def _populateLevelLocatorsModel( topoInfo ):
   for level, levelInfo in enumerate(
         [ topoInfo.srv6LevelL1Info, topoInfo.srv6LevelL2Info ], start=1 ):
      if levelInfo.locator:
         levelLocsModel = IsisSrv6ShowCliModel.IsisSrv6LevelLocators()
         levelLocsModel.locatorPrefixes = _populateLocatorModel( levelInfo )
         yield level, levelLocsModel

def _populateTopoLocatorsModel( srv6InstanceInfo ):
   for topoId, topoInfo in srv6InstanceInfo.srv6TopologyInfo.items():
      topoLocsModel = IsisSrv6ShowCliModel.IsisSrv6TopologyLocators()
      if topoInfo.srv6LevelL1Info.locator or topoInfo.srv6LevelL2Info.locator:
         topoLocsModel.levels = _populateLevelLocatorsModel( topoInfo )
         yield topoId, topoLocsModel

#----------------------------------------
# show isis segment-routing ipv6 locators
#----------------------------------------
def getSrv6InstanceLocatorsModel( mode, cmdPrefix=None, instanceId=None,
                                  instanceName=None, vrfName=None ):
   instConfig, instStatus = _getIsisSrv6ConfigAndStatus( mode, instanceId,
                                                         instanceName )
   if not instConfig or not instStatus:
      return None

   instLocsModel = IsisSrv6ShowCliModel.IsisInstanceSrv6Locators()
   if isisSrv6Shark:
      sharkStatus = SharkLazyMount.force( isisSrv6Shark )
      srv6InstanceInfo = sharkStatus.srv6InstanceInfo[ instConfig.instanceId ]
      instLocsModel.topologies = _populateTopoLocatorsModel( srv6InstanceInfo )
   return instLocsModel

def ShowIsisSrv6LocatorsCmdHandler ( mode, args ):

   del args[ 'segment-routing' ]
   del args[ 'ipv6' ]
   del args[ 'locators' ]
   args[ 'instDictModelType' ] = IsisSrv6ShowCliModel.IsisSrv6LocatorsModel
   args[ 'cmdVrfModel' ] = IsisSrv6ShowCliModel.IsisSrv6LocatorsVRFsModel
   return showIsisCommand( mode, getSrv6InstanceLocatorsModel, **args )
