# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliGlobal import CliGlobal
from CliPlugin.L1CardProfileDefinition import CardProfileDefinitionConfigMode
import ConfigMount
import LazyMount
from TypeFuture import TacLazyType

CardProfile = TacLazyType( 'L1Profile::CardProfile' )
CardProfileDescriptor = TacLazyType( 'L1Profile::CardProfileDescriptor' )
CardProfileSource = TacLazyType( 'L1Profile::CardProfileSource::CardProfileSource' )
GlobalConfig = TacLazyType( 'L1Profile::GlobalConfig' )
InterfaceSlotDescriptor = TacLazyType( 'L1Profile::InterfaceSlotDescriptor' )
InterfaceSlotProfileDescriptor = TacLazyType(
   'L1Profile::InterfaceSlotProfileDescriptor' )
InterfaceSlotProfileSource = TacLazyType(
   'L1Profile::InterfaceSlotProfileSource::InterfaceSlotProfileSource' )
IntfSlotProfileReader = TacLazyType( 'L1Profile::IntfSlotProfileReader' )
MountConstants = TacLazyType( 'L1Profile::MountConstants' )

gv = CliGlobal( dict( cardProfileLibraryCliDir=None,
                      intfSlotProfileLibraryRootDir=None ) )

class DefineCardProfile:

   @staticmethod
   def handler( mode, args ):
      profileName = args[ 'PROFILE' ]
      childMode = mode.childMode( CardProfileDefinitionConfigMode,
                                  profileName=profileName )
      mode.session_.gotoChildMode( childMode )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      profileName = args[ 'PROFILE' ]
      lastMode = mode.session_.modeOfLastPrompt()
      # If we are deleting the profile defined by the current config mode then make
      # sure that the profile does not get re-written back to Sysdb as the mode
      # exists and the transaction commits.
      if ( isinstance( lastMode, CardProfileDefinitionConfigMode ) and
           ( lastMode.profileName == profileName ) ):
         lastMode.profile = None

      for desc in gv.cardProfileLibraryCliDir.cardProfile:
         if desc.name == profileName:
            del gv.cardProfileLibraryCliDir.cardProfile[ desc ]

class AbortCardProfileDefinition:

   @staticmethod
   def handler( mode, args ):
      mode.abort()

class CardProfileDescription:

   @staticmethod
   def handler( mode, args ):
      mode.profile.description = args[ 'DESC' ]

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      mode.profile.description = ''

class InterfaceSlotProfileMap:

   @staticmethod
   def handler( mode, args ):
      # Config agent ingests the startup config before any of the builtin profiles
      # have had a chance to load. As such, disambiguating between the source of the
      # profile referenced by the CLI command is pointless. We always configure the
      # source as "unknown" and rely on the processing stages to resolve the unknown
      # source.
      desc = InterfaceSlotProfileDescriptor( InterfaceSlotProfileSource.unknown,
                                             args[ 'PROFILE' ] )

      intfSlotRangeMatch = args[ 'INTF_SLOT' ]
      for intfSlotId in intfSlotRangeMatch.intfNumbers():
         intfSlotDesc = InterfaceSlotDescriptor(
            intfSlotRangeMatch.type().tagLong, intfSlotId )
         mode.profile.intfSlotProfile[ intfSlotDesc ] = desc

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      intfSlotRangeMatch = args[ 'INTF_SLOT' ]
      for intfSlotId in intfSlotRangeMatch.intfNumbers():
         intfSlotDesc = InterfaceSlotDescriptor(
            intfSlotRangeMatch.type().tagLong, intfSlotId )
         del mode.profile.intfSlotProfile[ intfSlotDesc ]

def Plugin( entityManager ):
   gv.cardProfileLibraryCliDir = ConfigMount.mount(
      entityManager,
      MountConstants.cardProfileLibraryCliDirPath(),
      'L1Profile::CardProfileDir',
      'w' )
   gv.intfSlotProfileLibraryRootDir = LazyMount.mount(
      entityManager,
      MountConstants.intfSlotProfileLibraryRootDirPath(),
      'Tac::Dir',
      'ri' )
