# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentCommandRequest
import AgentDirectory
from CliPlugin.RcfCliLib import stripParens
from CliPlugin.RcfLibCliModels import (
      ShowAgentRcfDetailModel
)

def handlerShowMplsLdpRcfDetailCmd( mode, args ):
   command = 'ShowMplsLdpRcfDetail'
   if not AgentDirectory.agentIsRunning(
         mode.entityManager.sysname(), 'LdpAgent' ):
      mode.addWarning( "Agent 'LdpAgent' is not running" )
      return ShowAgentRcfDetailModel( functions={} )

   if 'FUNC_NAME' in args:
      funcNameParam = stripParens( args[ 'FUNC_NAME' ] )
      command += " rcf=" + funcNameParam
   AgentCommandRequest.runCliPrintSocketCommand(
         mode.entityManager, "LdpAgent", "LdpCliCallbackWithFormat", command,
         mode )
   return ShowAgentRcfDetailModel( functions={} )
