# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin
from CliModel import Dict, Model

XSEM = CliDynamicPlugin( 'XcvrShowEepromModel' )

# -------------------------------------------------------------------------------
# Models for "show line system [PORT X] eeprom"
# -------------------------------------------------------------------------------

class LineSystemEepromBase( Model ):
   interfaces = Dict( help="Mapping between port name and the EEPROM",
                      keyType=str, valueType=XSEM.InterfacesTransceiverEepromIntf )

   def render( self ) -> None:
      if not self.interfaces:
         return
      for intf in self.interfaces:
         self.interfaces[ intf ].renderIndented( 0, "  " )
         print()
