# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
from CliDynamicSymbol import CliDynamicPlugin
from TypeFuture import TacLazyType
from XcvrLib import getXcvrSlotName

from CliPlugin.XcvrShowStatusCliHandler import (
    _populatePolsChannelStatus, _populatePolsTransceiverStatusValues )
from CliPlugin.XcvrShowStatusModel import InterfacesTransceiverStatus

LSCL = CliDynamicPlugin( 'LineSystemCliLib' )
XcvrMediaType = TacLazyType( 'Xcvr::MediaType' )

# -------------------------------------------------------------------------------
# show line system [PORT X] status
# -------------------------------------------------------------------------------

def showInterfaceLineSystemStatus( mode, intfRange, mod ) ->\
     InterfacesTransceiverStatus:
   """
   Simplified version of _showInterfacesXcvrStatus specific to line systems
   with the ability to handle auxiliary slots.
   """
   model = InterfacesTransceiverStatus()

   slotNames = { getXcvrSlotName( intf ) for intf in intfRange }
   intfMapping = LSCL.mimicIntfMapping( slotNames )

   for intfToDisplay in sorted( intfMapping.laneMap, key=LSCL.subPrefixToPort ):
      portDisplayName = LSCL.subPrefixToPort( intfToDisplay )
      for intfName in Arnet.sortIntf( intfMapping.laneMap[ intfToDisplay ] ):
         # Line systems only publish a small subset of attributes, so populate the
         # model in a separate code path
         if portDisplayName not in model.ports:
            moduleModel = _populatePolsTransceiverStatusValues( intfToDisplay )
            model.ports[ portDisplayName ] = moduleModel
         _populatePolsChannelStatus( moduleModel, intfName, intfMapping,
                                     intfToDisplay )
   return model

def showLineSystemStatus( mode, args ) -> InterfacesTransceiverStatus:
   # Get the ports requested by the user.
   portRange = args.get( 'PORTRANGE' )
   # Interface range that will be passed into the _showInterfacesXcvrStatus method.
   intfRangeLineSys = LSCL.lineSystemIntfsInPortRange( mode, portRange )
   if not intfRangeLineSys:
      return InterfacesTransceiverStatus()

   return showInterfaceLineSystemStatus( mode, intfRangeLineSys, args.get( 'MOD' ) )
